/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.lazy.layout.IntervalList;
import androidx.compose.foundation.lazy.layout.IntervalListKt;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0002J2\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0012\u001a\u00020\tH\u0096\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u001a\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Landroidx/compose/foundation/lazy/layout/MutableIntervalList;", "T", "Landroidx/compose/foundation/lazy/layout/IntervalList;", "()V", "intervals", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/IntervalList$Interval;", "lastInterval", "<set-?>", "", "size", "getSize", "()I", "addInterval", "", "value", "(ILjava/lang/Object;)V", "checkIndexBounds", "index", "forEach", "fromIndex", "toIndex", "block", "Lkotlin/Function1;", "get", "getIntervalForIndex", "itemIndex", "contains", "", "foundation"})
@ExperimentalFoundationApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIntervalList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntervalList.kt\nandroidx/compose/foundation/lazy/layout/MutableIntervalList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,222:1\n1208#2:223\n1187#2,2:224\n523#3:226\n523#3:227\n523#3:228\n*S KotlinDebug\n*F\n+ 1 IntervalList.kt\nandroidx/compose/foundation/lazy/layout/MutableIntervalList\n*L\n104#1:223\n104#1:224,2\n156#1:226\n158#1:227\n175#1:228\n*E\n"})
public final class MutableIntervalList<T>
implements IntervalList<T> {
    @NotNull
    private final MutableVector<IntervalList.Interval<T>> intervals;
    private int size;
    @Nullable
    private IntervalList.Interval<? extends T> lastInterval;
    public static final int $stable = 8;

    public MutableIntervalList() {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.intervals = new MutableVector<IntervalList.Interval>(new IntervalList.Interval[capacity$iv$iv], 0);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public final void addInterval(int size2, T value) {
        if (!(size2 >= 0)) {
            boolean bl = false;
            String string = "size should be >=0, but was " + size2;
            throw new IllegalArgumentException(string.toString());
        }
        if (size2 == 0) {
            return;
        }
        IntervalList.Interval<T> interval = new IntervalList.Interval<T>(this.getSize(), size2, value);
        this.size = this.getSize() + size2;
        this.intervals.add(interval);
    }

    @Override
    public void forEach(int fromIndex, int toIndex, @NotNull Function1<? super IntervalList.Interval<? extends T>, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        this.checkIndexBounds(fromIndex);
        this.checkIndexBounds(toIndex);
        if (!(toIndex >= fromIndex)) {
            boolean $i$a$-require-MutableIntervalList$forEach$22 = false;
            String $i$a$-require-MutableIntervalList$forEach$22 = "toIndex (" + toIndex + ") should be not smaller than fromIndex (" + fromIndex + ')';
            throw new IllegalArgumentException($i$a$-require-MutableIntervalList$forEach$22.toString());
        }
        int intervalIndex = IntervalListKt.access$binarySearch(this.intervals, fromIndex);
        MutableVector<IntervalList.Interval<T>> this_$iv = this.intervals;
        boolean $i$f$get = false;
        int itemIndex = this_$iv.getContent()[intervalIndex].getStartIndex();
        while (itemIndex <= toIndex) {
            MutableVector<IntervalList.Interval<T>> this_$iv2 = this.intervals;
            boolean $i$f$get2 = false;
            IntervalList.Interval<T> interval = this_$iv2.getContent()[intervalIndex];
            block2.invoke(interval);
            itemIndex += interval.getSize();
            ++intervalIndex;
        }
    }

    @Override
    @NotNull
    public IntervalList.Interval<T> get(int index2) {
        this.checkIndexBounds(index2);
        return this.getIntervalForIndex(index2);
    }

    /*
     * WARNING - void declaration
     */
    private final IntervalList.Interval<T> getIntervalForIndex(int itemIndex) {
        IntervalList.Interval interval;
        IntervalList.Interval lastInterval = this.lastInterval;
        if (lastInterval != null && this.contains(lastInterval, itemIndex)) {
            interval = lastInterval;
        } else {
            void this_$iv;
            MutableVector<IntervalList.Interval<T>> mutableVector = this.intervals;
            int index$iv = IntervalListKt.access$binarySearch(this.intervals, itemIndex);
            boolean $i$f$get = false;
            mutableVector = this_$iv.getContent()[index$iv];
            IntervalList.Interval it = (IntervalList.Interval)((Object)mutableVector);
            boolean bl = false;
            this.lastInterval = it;
            interval = (IntervalList.Interval)((Object)mutableVector);
        }
        return interval;
    }

    private final void checkIndexBounds(int index2) {
        if (!(0 <= index2 ? index2 < this.getSize() : false)) {
            throw new IndexOutOfBoundsException("Index " + index2 + ", size " + this.getSize());
        }
    }

    private final boolean contains(IntervalList.Interval<? extends T> $this$contains, int index2) {
        int n = $this$contains.getStartIndex();
        return index2 < $this$contains.getStartIndex() + $this$contains.getSize() ? n <= index2 : false;
    }
}

