/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.nestedscroll.NestedScrollConnection;
import androidx.compose.ui.input.nestedscroll.NestedScrollSource;
import androidx.compose.ui.unit.Velocity;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001c\u0010\u001a\u001a\u00020\f*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0016\u0010\u001e\u001a\u00020\u001f*\u00020\u0012H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"Landroidx/compose/foundation/pager/DefaultPagerNestedScrollConnection;", "Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;", "state", "Landroidx/compose/foundation/pager/PagerState;", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/gestures/Orientation;)V", "getOrientation", "()Landroidx/compose/foundation/gestures/Orientation;", "getState", "()Landroidx/compose/foundation/pager/PagerState;", "onPostFling", "Landroidx/compose/ui/unit/Velocity;", "consumed", "available", "onPostFling-RZ2iAVY", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onPostScroll", "Landroidx/compose/ui/geometry/Offset;", "source", "Landroidx/compose/ui/input/nestedscroll/NestedScrollSource;", "onPostScroll-DzOQY0M", "(JJI)J", "onPreScroll", "onPreScroll-OzD1aCk", "(JI)J", "consumeOnOrientation", "consumeOnOrientation-8S9VItk", "(JLandroidx/compose/foundation/gestures/Orientation;)J", "consumeOnOrientation-QWom1Mo", "mainAxis", "", "mainAxis-k-4lQ0M", "(J)F", "foundation"})
final class DefaultPagerNestedScrollConnection
implements NestedScrollConnection {
    @NotNull
    private final PagerState state;
    @NotNull
    private final Orientation orientation;

    public DefaultPagerNestedScrollConnection(@NotNull PagerState state2, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter(state2, "state");
        Intrinsics.checkNotNullParameter((Object)orientation, "orientation");
        this.state = state2;
        this.orientation = orientation;
    }

    @NotNull
    public final PagerState getState() {
        return this.state;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final long consumeOnOrientation-QWom1Mo(long $this$consumeOnOrientation_u2dQWom1Mo, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)orientation, "orientation");
        return orientation == Orientation.Vertical ? Velocity.copy-OhffZ5M$default($this$consumeOnOrientation_u2dQWom1Mo, 0.0f, 0.0f, 2, null) : Velocity.copy-OhffZ5M$default($this$consumeOnOrientation_u2dQWom1Mo, 0.0f, 0.0f, 1, null);
    }

    public final long consumeOnOrientation-8S9VItk(long $this$consumeOnOrientation_u2d8S9VItk, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)orientation, "orientation");
        return orientation == Orientation.Vertical ? Offset.copy-dBAh8RU$default($this$consumeOnOrientation_u2d8S9VItk, 0.0f, 0.0f, 2, null) : Offset.copy-dBAh8RU$default($this$consumeOnOrientation_u2d8S9VItk, 0.0f, 0.0f, 1, null);
    }

    @Override
    public long onPreScroll-OzD1aCk(long available, int source2) {
        long l;
        if (NestedScrollSource.equals-impl0(source2, NestedScrollSource.Companion.getDrag-WNlRxjI()) && (double)Math.abs(this.state.getCurrentPageOffsetFraction()) > 0.0) {
            float currentPageOffset = this.state.getCurrentPageOffsetFraction() * (float)this.state.getPageSize$foundation();
            int pageAvailableSpace = this.state.getLayoutInfo().getPageSize() + this.state.getLayoutInfo().getPageSpacing();
            float nextClosestPageOffset = currentPageOffset + (float)pageAvailableSpace * -Math.signum(this.state.getCurrentPageOffsetFraction());
            float minBound = 0.0f;
            float maxBound = 0.0f;
            if (this.state.getCurrentPageOffsetFraction() > 0.0f) {
                minBound = nextClosestPageOffset;
                maxBound = currentPageOffset;
            } else {
                minBound = currentPageOffset;
                maxBound = nextClosestPageOffset;
            }
            float delta = this.orientation == Orientation.Horizontal ? Offset.getX-impl(available) : Offset.getY-impl(available);
            float coerced = RangesKt.coerceIn(delta, minBound, maxBound);
            float consumed = -this.state.dispatchRawDelta(-coerced);
            l = Offset.copy-dBAh8RU(available, this.orientation == Orientation.Horizontal ? consumed : Offset.getX-impl(available), this.orientation == Orientation.Vertical ? consumed : Offset.getY-impl(available));
        } else {
            l = Offset.Companion.getZero-F1C5BW0();
        }
        return l;
    }

    @Override
    public long onPostScroll-DzOQY0M(long consumed, long available, int source2) {
        if (NestedScrollSource.equals-impl0(source2, NestedScrollSource.Companion.getFling-WNlRxjI()) && !(this.mainAxis-k-4lQ0M(available) == 0.0f)) {
            throw new CancellationException("End of scrollable area reached");
        }
        return Offset.Companion.getZero-F1C5BW0();
    }

    @Override
    @Nullable
    public Object onPostFling-RZ2iAVY(long consumed, long available, @NotNull Continuation<? super Velocity> $completion) {
        return Velocity.box-impl(this.consumeOnOrientation-QWom1Mo(available, this.orientation));
    }

    private final float mainAxis-k-4lQ0M(long $this$mainAxis_u2dk_u2d4lQ0M) {
        return this.orientation == Orientation.Horizontal ? Offset.getX-impl($this$mainAxis_u2dk_u2d4lQ0M) : Offset.getY-impl($this$mainAxis_u2dk_u2d4lQ0M);
    }
}

