/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.CalendarModel_skikoKt;
import androidx.compose.material3.DatePickerFormatter;
import androidx.compose.runtime.Immutable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0096\u0002J-\u0010\u0011\u001a\u0004\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001e"}, d2={"Landroidx/compose/material3/DatePickerFormatterImpl;", "Landroidx/compose/material3/DatePickerFormatter;", "yearSelectionSkeleton", "", "selectedDateSkeleton", "selectedDateDescriptionSkeleton", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "formatterCache", "", "", "getSelectedDateDescriptionSkeleton", "()Ljava/lang/String;", "getSelectedDateSkeleton", "getYearSelectionSkeleton", "equals", "", "other", "formatDate", "dateMillis", "", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "forContentDescription", "(Ljava/lang/Long;Ljava/util/Locale;Z)Ljava/lang/String;", "formatMonthYear", "monthMillis", "(Ljava/lang/Long;Ljava/util/Locale;)Ljava/lang/String;", "hashCode", "", "material3"})
@Immutable
final class DatePickerFormatterImpl
implements DatePickerFormatter {
    @NotNull
    private final String yearSelectionSkeleton;
    @NotNull
    private final String selectedDateSkeleton;
    @NotNull
    private final String selectedDateDescriptionSkeleton;
    @NotNull
    private final Map<String, Object> formatterCache;

    public DatePickerFormatterImpl(@NotNull String yearSelectionSkeleton, @NotNull String selectedDateSkeleton, @NotNull String selectedDateDescriptionSkeleton) {
        Intrinsics.checkNotNullParameter(yearSelectionSkeleton, "yearSelectionSkeleton");
        Intrinsics.checkNotNullParameter(selectedDateSkeleton, "selectedDateSkeleton");
        Intrinsics.checkNotNullParameter(selectedDateDescriptionSkeleton, "selectedDateDescriptionSkeleton");
        this.yearSelectionSkeleton = yearSelectionSkeleton;
        this.selectedDateSkeleton = selectedDateSkeleton;
        this.selectedDateDescriptionSkeleton = selectedDateDescriptionSkeleton;
        this.formatterCache = new LinkedHashMap();
    }

    @NotNull
    public final String getYearSelectionSkeleton() {
        return this.yearSelectionSkeleton;
    }

    @NotNull
    public final String getSelectedDateSkeleton() {
        return this.selectedDateSkeleton;
    }

    @NotNull
    public final String getSelectedDateDescriptionSkeleton() {
        return this.selectedDateDescriptionSkeleton;
    }

    @Override
    @Nullable
    public String formatMonthYear(@Nullable Long monthMillis, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        if (monthMillis == null) {
            return null;
        }
        return CalendarModel_skikoKt.formatWithSkeleton(monthMillis, this.yearSelectionSkeleton, locale, this.formatterCache);
    }

    @Override
    @Nullable
    public String formatDate(@Nullable Long dateMillis, @NotNull Locale locale, boolean forContentDescription) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        if (dateMillis == null) {
            return null;
        }
        return CalendarModel_skikoKt.formatWithSkeleton(dateMillis, forContentDescription ? this.selectedDateDescriptionSkeleton : this.selectedDateSkeleton, locale, this.formatterCache);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DatePickerFormatterImpl)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.yearSelectionSkeleton, ((DatePickerFormatterImpl)other).yearSelectionSkeleton)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.selectedDateSkeleton, ((DatePickerFormatterImpl)other).selectedDateSkeleton)) {
            return false;
        }
        return Intrinsics.areEqual(this.selectedDateDescriptionSkeleton, ((DatePickerFormatterImpl)other).selectedDateDescriptionSkeleton);
    }

    public int hashCode() {
        int result2 = this.yearSelectionSkeleton.hashCode();
        result2 = 31 * result2 + this.selectedDateSkeleton.hashCode();
        result2 = 31 * result2 + this.selectedDateDescriptionSkeleton.hashCode();
        return result2;
    }
}

