/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.DataIterator;
import androidx.compose.runtime.GroupIterator;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.RecomposeScopeImpl;
import androidx.compose.runtime.SlotReader;
import androidx.compose.runtime.SlotTableGroup;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.SlotWriter;
import androidx.compose.runtime.SynchronizedObject;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.tooling.CompositionData;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010(\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0015J\u000e\u00107\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u0007J\u0006\u00108\u001a\u000209J=\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2&\u0010'\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)\u0018\u00010(j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)\u0018\u0001`*H\u0000\u00a2\u0006\u0002\b>J\u007f\u0010:\u001a\u00020;2\u0006\u00103\u001a\u00020?2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00152\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u0006\u0010%\u001a\u00020\u00152\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b2&\u0010'\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)\u0018\u00010(j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)\u0018\u0001`*H\u0000\u00a2\u0006\u0004\b>\u0010@J\u0006\u0010A\u001a\u00020\u001aJ\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00150CH\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010\u00032\u0006\u0010E\u001a\u00020 H\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\u0015H\u0002J\u0016\u0010I\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u0007J\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00150CH\u0002J\u001d\u0010L\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010C2\u0006\u0010M\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bNJ\u000f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00030PH\u0096\u0002J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00150CH\u0002J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00150CH\u0002J\u0006\u0010S\u001a\u00020=J\u0006\u0010T\u001a\u00020?J\u000e\u0010U\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u0007J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00150CH\u0002J:\u0010W\u001a\u0002HX\"\u0004\b\u0000\u0010X2!\u0010Y\u001a\u001d\u0012\u0013\u0012\u00110=\u00a2\u0006\f\b[\u0012\b\b\\\u0012\u0004\b\b(<\u0012\u0004\u0012\u0002HX0ZH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010]Jw\u0010^\u001a\u00020;2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00152\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u0006\u0010%\u001a\u00020\u00152\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b2&\u0010'\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)\u0018\u00010(j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)\u0018\u0001`*H\u0000\u00a2\u0006\u0004\b_\u0010`J\u001f\u0010a\u001a\u0004\u0018\u00010 2\u0006\u0010H\u001a\u00020\u00152\u0006\u0010b\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bcJ\u001d\u0010d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0C2\u0006\u0010H\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\beJ\u0010\u0010f\u001a\u0004\u0018\u00010)2\u0006\u0010H\u001a\u00020\u0015J\u0010\u0010g\u001a\u0004\u0018\u00010\u00072\u0006\u00106\u001a\u00020\u0015J\u0006\u0010h\u001a\u00020;J:\u0010i\u001a\u0002HX\"\u0004\b\u0000\u0010X2!\u0010Y\u001a\u001d\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b[\u0012\b\b\\\u0012\u0004\b\b(3\u0012\u0004\u0012\u0002HX0ZH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010]J \u0010j\u001a\u00020\u0015*\u00060kj\u0002`l2\u0006\u00106\u001a\u00020\u00152\u0006\u0010m\u001a\u00020\u0015H\u0002R*\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R\u001e\u0010%\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018R:\u0010'\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)\u0018\u00010(j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)\u0018\u0001`*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0018\"\u0004\b1\u00102R\u001e\u00103\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u001a@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006n"}, d2={"Landroidx/compose/runtime/SlotTable;", "Landroidx/compose/runtime/tooling/CompositionData;", "", "Landroidx/compose/runtime/tooling/CompositionGroup;", "()V", "anchors", "Ljava/util/ArrayList;", "Landroidx/compose/runtime/Anchor;", "Lkotlin/collections/ArrayList;", "getAnchors$runtime", "()Ljava/util/ArrayList;", "setAnchors$runtime", "(Ljava/util/ArrayList;)V", "compositionGroups", "getCompositionGroups", "()Ljava/lang/Iterable;", "<set-?>", "", "groups", "getGroups", "()[I", "", "groupsSize", "getGroupsSize", "()I", "isEmpty", "", "()Z", "lock", "Landroidx/compose/runtime/SynchronizedObject;", "readers", "", "", "slots", "getSlots", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "slotsSize", "getSlotsSize", "sourceInformationMap", "Ljava/util/HashMap;", "Landroidx/compose/runtime/GroupSourceInformation;", "Lkotlin/collections/HashMap;", "getSourceInformationMap$runtime", "()Ljava/util/HashMap;", "setSourceInformationMap$runtime", "(Ljava/util/HashMap;)V", "version", "getVersion$runtime", "setVersion$runtime", "(I)V", "writer", "getWriter$runtime", "anchor", "index", "anchorIndex", "asString", "", "close", "", "reader", "Landroidx/compose/runtime/SlotReader;", "close$runtime", "Landroidx/compose/runtime/SlotWriter;", "(Landroidx/compose/runtime/SlotWriter;[II[Ljava/lang/Object;ILjava/util/ArrayList;Ljava/util/HashMap;)V", "containsMark", "dataIndexes", "", "find", "identityToFind", "findEffectiveRecomposeScope", "Landroidx/compose/runtime/RecomposeScopeImpl;", "group", "groupContainsAnchor", "groupIndex", "groupSizes", "invalidateGroupsWithKey", "target", "invalidateGroupsWithKey$runtime", "iterator", "", "keys", "nodes", "openReader", "openWriter", "ownsAnchor", "parentIndexes", "read", "T", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "setTo", "setTo$runtime", "([II[Ljava/lang/Object;ILjava/util/ArrayList;Ljava/util/HashMap;)V", "slot", "slotIndex", "slot$runtime", "slotsOf", "slotsOf$runtime", "sourceInformationOf", "tryAnchor", "verifyWellFormed", "write", "emitGroup", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n+ 5 Synchronization.kt\nandroidx/compose/runtime/SynchronizationKt\n+ 6 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n*L\n1#1,3747:1\n152#1,8:3796\n168#1,4:3804\n173#1,3:3814\n4179#2,5:3748\n4179#2,5:3753\n4179#2,5:3758\n4179#2,5:3770\n4179#2,5:3775\n4179#2,5:3780\n4179#2,5:3785\n4179#2,5:3790\n1#3:3763\n3618#4,6:3764\n33#5:3795\n33#6,6:3808\n33#6,6:3817\n33#6,6:3823\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n*L\n340#1:3796,8\n369#1:3804,4\n369#1:3814,3\n196#1:3748,5\n197#1:3753,5\n213#1:3758,5\n224#1:3770,5\n235#1:3775,5\n255#1:3780,5\n256#1:3785,5\n268#1:3790,5\n215#1:3764,6\n271#1:3795\n371#1:3808,6\n502#1:3817,6\n511#1:3823,6\n*E\n"})
public final class SlotTable
implements CompositionData,
Iterable<CompositionGroup>,
KMappedMarker {
    @NotNull
    private int[] groups = new int[0];
    private int groupsSize;
    @NotNull
    private Object[] slots;
    private int slotsSize;
    private int readers;
    @NotNull
    private final SynchronizedObject lock;
    private boolean writer;
    private int version;
    @NotNull
    private ArrayList<Anchor> anchors;
    @Nullable
    private HashMap<Anchor, GroupSourceInformation> sourceInformationMap;
    public static final int $stable = 8;

    public SlotTable() {
        int n = 0;
        Object[] objectArray = new Object[]{};
        SlotTable slotTable = this;
        while (n < 0) {
            int n2 = n++;
            objectArray[n2] = null;
        }
        slotTable.slots = objectArray;
        this.lock = new SynchronizedObject();
        this.anchors = new ArrayList();
    }

    @NotNull
    public final int[] getGroups() {
        return this.groups;
    }

    public final int getGroupsSize() {
        return this.groupsSize;
    }

    @NotNull
    public final Object[] getSlots() {
        return this.slots;
    }

    public final int getSlotsSize() {
        return this.slotsSize;
    }

    public final boolean getWriter$runtime() {
        return this.writer;
    }

    public final int getVersion$runtime() {
        return this.version;
    }

    public final void setVersion$runtime(int n) {
        this.version = n;
    }

    @NotNull
    public final ArrayList<Anchor> getAnchors$runtime() {
        return this.anchors;
    }

    public final void setAnchors$runtime(@NotNull ArrayList<Anchor> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.anchors = arrayList;
    }

    @Nullable
    public final HashMap<Anchor, GroupSourceInformation> getSourceInformationMap$runtime() {
        return this.sourceInformationMap;
    }

    public final void setSourceInformationMap$runtime(@Nullable HashMap<Anchor, GroupSourceInformation> hashMap) {
        this.sourceInformationMap = hashMap;
    }

    @Override
    public boolean isEmpty() {
        return this.groupsSize == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T read(@NotNull Function1<? super SlotReader, ? extends T> block2) {
        T t;
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$read = false;
        SlotReader reader = this.openReader();
        boolean bl = false;
        try {
            t = block2.invoke(reader);
        }
        finally {
            InlineMarker.finallyStart(1);
            reader.close();
            InlineMarker.finallyEnd(1);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T write(@NotNull Function1<? super SlotWriter, ? extends T> block2) {
        T t;
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$write = false;
        SlotWriter writer = this.openWriter();
        boolean bl = false;
        try {
            t = block2.invoke(writer);
        }
        finally {
            InlineMarker.finallyStart(1);
            writer.close();
            InlineMarker.finallyEnd(1);
        }
        return t;
    }

    @NotNull
    public final SlotReader openReader() {
        if (this.writer) {
            throw new IllegalStateException("Cannot read while a writer is pending".toString());
        }
        int n = this.readers;
        this.readers = n + 1;
        return new SlotReader(this);
    }

    @NotNull
    public final SlotWriter openWriter() {
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot start a writer when another writer is pending";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        value$iv = this.readers <= 0;
        $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot start a writer when a reader is pending";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.writer = true;
        int n = this.version;
        this.version = n + 1;
        return new SlotWriter(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Anchor anchor(int index2) {
        Anchor anchor;
        void $this$getOrAdd$iv;
        boolean value$iv22 = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv22) {
            boolean bl = false;
            String message$iv = "use active SlotWriter to create an anchor location instead";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        if (!(0 <= index2 ? index2 < this.groupsSize : false)) {
            boolean $i$a$-require-SlotTable$anchor$32 = false;
            String $i$a$-require-SlotTable$anchor$32 = "Parameter index is out of range";
            throw new IllegalArgumentException($i$a$-require-SlotTable$anchor$32.toString());
        }
        ArrayList<Anchor> value$iv22 = this.anchors;
        int effectiveSize$iv = this.groupsSize;
        boolean $i$f$getOrAdd = false;
        int location$iv = SlotTableKt.access$search((ArrayList)$this$getOrAdd$iv, index2, effectiveSize$iv);
        if (location$iv < 0) {
            boolean bl = false;
            Anchor anchor$iv = new Anchor(index2);
            $this$getOrAdd$iv.add(-(location$iv + 1), anchor$iv);
            anchor = anchor$iv;
        } else {
            Object e = $this$getOrAdd$iv.get(location$iv);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            anchor = (Anchor)e;
        }
        return anchor;
    }

    @Nullable
    public final Anchor tryAnchor(int index2) {
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "use active SlotWriter to crate an anchor for location instead";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        return (0 <= index2 ? index2 < this.groupsSize : false) ? SlotTableKt.access$find(this.anchors, index2, this.groupsSize) : null;
    }

    public final int anchorIndex(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Use active SlotWriter to determine anchor location instead";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        if (!anchor.getValid()) {
            boolean bl = false;
            String string = "Anchor refers to a group that was removed";
            throw new IllegalArgumentException(string.toString());
        }
        return anchor.getLocation$runtime();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean ownsAnchor(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        if (!anchor.getValid()) return false;
        int it = SlotTableKt.access$search(this.anchors, anchor.getLocation$runtime(), this.groupsSize);
        boolean bl = false;
        if (it < 0) return false;
        if (!Intrinsics.areEqual(this.anchors.get(it), anchor)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean groupContainsAnchor(int groupIndex, @NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        boolean value$iv = !this.writer;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Writer is active";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        value$iv = 0 <= groupIndex ? groupIndex < this.groupsSize : false;
        $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Invalid group index";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        if (!this.ownsAnchor(anchor)) return false;
        int n = groupIndex + SlotTableKt.access$groupSize(this.groups, groupIndex);
        int n2 = anchor.getLocation$runtime();
        if (groupIndex > n2) return false;
        if (n2 >= n) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$runtime(@NotNull SlotReader reader, @Nullable HashMap<Anchor, GroupSourceInformation> sourceInformationMap) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        int value$iv = reader.getTable$runtime() == this && this.readers > 0 ? 1 : 0;
        boolean $i$f$runtimeCheck = false;
        if (value$iv == 0) {
            boolean bl = false;
            String message$iv = "Unexpected reader close()";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        value$iv = this.readers;
        this.readers = value$iv + -1;
        if (sourceInformationMap != null) {
            SynchronizedObject lock$iv = this.lock;
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                HashMap<Anchor, GroupSourceInformation> thisMap = this.sourceInformationMap;
                if (thisMap != null) {
                    thisMap.putAll((Map<Anchor, GroupSourceInformation>)sourceInformationMap);
                } else {
                    this.sourceInformationMap = sourceInformationMap;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void close$runtime(@NotNull SlotWriter writer, @NotNull int[] groups2, int groupsSize, @NotNull Object[] slots, int slotsSize, @NotNull ArrayList<Anchor> anchors2, @Nullable HashMap<Anchor, GroupSourceInformation> sourceInformationMap) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(groups2, "groups");
        Intrinsics.checkNotNullParameter(slots, "slots");
        Intrinsics.checkNotNullParameter(anchors2, "anchors");
        if (!(writer.getTable$runtime() == this && this.writer)) {
            boolean bl = false;
            String string = "Unexpected writer close()";
            throw new IllegalArgumentException(string.toString());
        }
        this.writer = false;
        this.setTo$runtime(groups2, groupsSize, slots, slotsSize, anchors2, sourceInformationMap);
    }

    public final void setTo$runtime(@NotNull int[] groups2, int groupsSize, @NotNull Object[] slots, int slotsSize, @NotNull ArrayList<Anchor> anchors2, @Nullable HashMap<Anchor, GroupSourceInformation> sourceInformationMap) {
        Intrinsics.checkNotNullParameter(groups2, "groups");
        Intrinsics.checkNotNullParameter(slots, "slots");
        Intrinsics.checkNotNullParameter(anchors2, "anchors");
        this.groups = groups2;
        this.groupsSize = groupsSize;
        this.slots = slots;
        this.slotsSize = slotsSize;
        this.anchors = anchors2;
        this.sourceInformationMap = sourceInformationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<RecomposeScopeImpl> invalidateGroupsWithKey$runtime(int target) {
        List anchors2 = new ArrayList();
        List scopes = new ArrayList();
        Ref.BooleanRef allScopesFound = new Ref.BooleanRef();
        allScopesFound.element = true;
        SlotTable this_$iv = this;
        boolean $i$f$read = false;
        boolean bl = false;
        try (SlotReader reader$iv = this_$iv.openReader();){
            SlotReader reader = reader$iv;
            boolean bl2 = false;
            SlotTable.invalidateGroupsWithKey$lambda$16$scanGroup(reader, target, anchors2, allScopesFound, this, scopes);
            Unit unit = Unit.INSTANCE;
        }
        this_$iv = this;
        boolean $i$f$write = false;
        boolean bl3 = false;
        try (SlotWriter writer$iv = this_$iv.openWriter();){
            SlotWriter writer = writer$iv;
            boolean bl4 = false;
            writer.startGroup();
            List $this$fastForEach$iv = anchors2;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                Anchor anchor = (Anchor)item$iv;
                boolean bl5 = false;
                if (anchor.toIndexFor(writer) < writer.getCurrentGroup()) continue;
                writer.seek(anchor);
                writer.bashCurrentGroup();
            }
            writer.skipToGroupEnd();
            int n2 = writer.endGroup();
        }
        return allScopesFound.element ? scopes : null;
    }

    public final boolean containsMark() {
        return this.groupsSize > 0 && SlotTableKt.access$containsMark(this.groups, 0);
    }

    @Nullable
    public final GroupSourceInformation sourceInformationOf(int group) {
        GroupSourceInformation groupSourceInformation;
        HashMap<Anchor, GroupSourceInformation> hashMap = this.sourceInformationMap;
        if (hashMap != null) {
            HashMap<Anchor, GroupSourceInformation> map2 = hashMap;
            boolean bl = false;
            Anchor anchor = this.tryAnchor(group);
            if (anchor != null) {
                Anchor anchor2 = anchor;
                boolean bl2 = false;
                groupSourceInformation = map2.get(anchor2);
            } else {
                groupSourceInformation = null;
            }
        } else {
            groupSourceInformation = null;
        }
        return groupSourceInformation;
    }

    private final RecomposeScopeImpl findEffectiveRecomposeScope(int group) {
        int current = group;
        while (current > 0) {
            for (Object data2 : new DataIterator(this, current)) {
                if (!(data2 instanceof RecomposeScopeImpl)) continue;
                if (((RecomposeScopeImpl)data2).getUsed() && current != group) {
                    return (RecomposeScopeImpl)data2;
                }
                ((RecomposeScopeImpl)data2).setForcedRecompose(true);
            }
            current = SlotTableKt.access$parentAnchor(this.groups, current);
        }
        return null;
    }

    public final void verifyWellFormed() {
        block10: {
            Ref.IntRef current = new Ref.IntRef();
            if (this.groupsSize > 0) {
                while (current.element < this.groupsSize) {
                    SlotTable.verifyWellFormed$validateGroup(current, this, -1, current.element + SlotTableKt.access$groupSize(this.groups, current.element));
                }
                if (!(current.element == this.groupsSize)) {
                    boolean $i$a$-check-SlotTable$verifyWellFormed$32 = false;
                    String $i$a$-check-SlotTable$verifyWellFormed$32 = "Incomplete group at root " + current.element + " expected to be " + this.groupsSize;
                    throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$32.toString());
                }
            }
            int $i$a$-check-SlotTable$verifyWellFormed$32 = this.slots.length;
            for (int index2 = this.slotsSize; index2 < $i$a$-check-SlotTable$verifyWellFormed$32; ++index2) {
                if (this.slots[index2] == null) continue;
                boolean $i$a$-check-SlotTable$verifyWellFormed$42 = false;
                String $i$a$-check-SlotTable$verifyWellFormed$42 = "Non null value in the slot gap at index " + index2;
                throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$42.toString());
            }
            int lastLocation = 0;
            lastLocation = -1;
            List $this$fastForEach$iv = this.anchors;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                Anchor anchor = (Anchor)item$iv;
                boolean bl = false;
                int location = anchor.toIndexFor(this);
                if (!(0 <= location ? location <= this.groupsSize : false)) {
                    boolean $i$a$-require-SlotTable$verifyWellFormed$3$32 = false;
                    String $i$a$-require-SlotTable$verifyWellFormed$3$32 = "Invalid anchor, location out of bound";
                    throw new IllegalArgumentException($i$a$-require-SlotTable$verifyWellFormed$3$32.toString());
                }
                if (!(lastLocation < location)) {
                    boolean $i$a$-require-SlotTable$verifyWellFormed$3$42 = false;
                    String $i$a$-require-SlotTable$verifyWellFormed$3$42 = "Anchor is out of order";
                    throw new IllegalArgumentException($i$a$-require-SlotTable$verifyWellFormed$3$42.toString());
                }
                lastLocation = location;
            }
            HashMap<Anchor, GroupSourceInformation> hashMap = this.sourceInformationMap;
            if (hashMap == null) break block10;
            HashMap<Anchor, GroupSourceInformation> sourceInformationMap = hashMap;
            boolean bl = false;
            for (Map.Entry entry : ((Map)sourceInformationMap).entrySet()) {
                Anchor anchor = (Anchor)entry.getKey();
                GroupSourceInformation sourceGroup = (GroupSourceInformation)entry.getValue();
                if (!anchor.getValid()) {
                    boolean $i$a$-require-SlotTable$verifyWellFormed$4$32 = false;
                    String $i$a$-require-SlotTable$verifyWellFormed$4$32 = "Source map contains invalid anchor";
                    throw new IllegalArgumentException($i$a$-require-SlotTable$verifyWellFormed$4$32.toString());
                }
                if (!this.ownsAnchor(anchor)) {
                    boolean bl2 = false;
                    String string = "Source map anchor is not owned by the slot table";
                    throw new IllegalArgumentException(string.toString());
                }
                SlotTable.verifyWellFormed$verifySourceGroup(this, sourceGroup);
            }
        }
    }

    @NotNull
    public final String asString() {
        String string;
        if (this.writer) {
            string = super.toString();
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$asString_u24lambda_u2443 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$asString_u24lambda_u2443.append(super.toString());
            $this$asString_u24lambda_u2443.append('\n');
            int groupsSize = this.groupsSize;
            if (groupsSize > 0) {
                for (int current = 0; current < groupsSize; current += this.emitGroup($this$asString_u24lambda_u2443, current, 0)) {
                }
            } else {
                $this$asString_u24lambda_u2443.append("<EMPTY>");
            }
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        }
        return string;
    }

    private final int emitGroup(StringBuilder $this$emitGroup, int index2, int level) {
        int n = 0;
        while (n < level) {
            int it = n++;
            boolean bl = false;
            $this$emitGroup.append(' ');
        }
        $this$emitGroup.append("Group(");
        $this$emitGroup.append(index2);
        $this$emitGroup.append(")");
        Anchor anchor = this.tryAnchor(index2);
        if (anchor != null) {
            Anchor anchor2 = anchor;
            boolean bl = false;
            HashMap<Anchor, GroupSourceInformation> hashMap = this.sourceInformationMap;
            if (hashMap != null && (hashMap = hashMap.get(anchor2)) != null) {
                HashMap<Anchor, GroupSourceInformation> groupInformation = hashMap;
                boolean bl2 = false;
                String string = ((GroupSourceInformation)((Object)groupInformation)).getSourceInformation();
                if (string != null) {
                    String it = string;
                    boolean bl3 = false;
                    if (StringsKt.startsWith$default(it, "C(", false, 2, null) || StringsKt.startsWith$default(it, "CC(", false, 2, null)) {
                        int start2 = StringsKt.indexOf$default((CharSequence)it, "(", 0, false, 6, null) + 1;
                        int endParen = StringsKt.indexOf$default((CharSequence)it, ')', 0, false, 6, null);
                        $this$emitGroup.append(" ");
                        String string2 = it.substring(start2, endParen);
                        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                        $this$emitGroup.append(string2);
                        $this$emitGroup.append("()");
                    }
                }
            }
        }
        $this$emitGroup.append(" key=");
        $this$emitGroup.append(SlotTableKt.access$key(this.groups, index2));
        int groupSize = SlotTableKt.access$groupSize(this.groups, index2);
        $this$emitGroup.append(", nodes=");
        $this$emitGroup.append(SlotTableKt.access$nodeCount(this.groups, index2));
        $this$emitGroup.append(", size=");
        $this$emitGroup.append(groupSize);
        if (SlotTableKt.access$hasMark(this.groups, index2)) {
            $this$emitGroup.append(", mark");
        }
        if (SlotTableKt.access$containsMark(this.groups, index2)) {
            $this$emitGroup.append(", contains mark");
        }
        int dataStart = SlotTable.emitGroup$dataIndex(this, index2);
        int dataEnd = SlotTable.emitGroup$dataIndex(this, index2 + 1);
        boolean bl = 0 <= dataStart ? dataStart <= dataEnd : false;
        if (bl && dataEnd <= this.slotsSize) {
            int slotStart;
            if (SlotTableKt.access$hasObjectKey(this.groups, index2)) {
                $this$emitGroup.append(" objectKey=" + this.slots[SlotTableKt.access$objectKeyIndex(this.groups, index2)]);
            }
            if (SlotTableKt.access$isNode(this.groups, index2)) {
                $this$emitGroup.append(" node=" + this.slots[SlotTableKt.access$nodeIndex(this.groups, index2)]);
            }
            if (SlotTableKt.access$hasAux(this.groups, index2)) {
                $this$emitGroup.append(" aux=" + this.slots[SlotTableKt.access$auxIndex(this.groups, index2)]);
            }
            if ((slotStart = SlotTableKt.access$slotAnchor(this.groups, index2)) < dataEnd) {
                $this$emitGroup.append(", slots=[");
                $this$emitGroup.append(slotStart);
                $this$emitGroup.append(": ");
                for (int dataIndex = slotStart; dataIndex < dataEnd; ++dataIndex) {
                    if (dataIndex != slotStart) {
                        $this$emitGroup.append(", ");
                    }
                    $this$emitGroup.append(String.valueOf(this.slots[dataIndex]));
                }
                $this$emitGroup.append("]");
            }
        } else {
            $this$emitGroup.append(", *invalid data offsets " + dataStart + '-' + dataEnd + '*');
        }
        $this$emitGroup.append('\n');
        int end2 = index2 + groupSize;
        for (int current = index2 + 1; current < end2; current += this.emitGroup($this$emitGroup, current, level + 1)) {
        }
        return groupSize;
    }

    private final List<Integer> keys() {
        return SlotTableKt.access$keys(this.groups, this.groupsSize * 5);
    }

    private final List<Integer> nodes() {
        return SlotTableKt.access$nodeCounts(this.groups, this.groupsSize * 5);
    }

    private final List<Integer> parentIndexes() {
        return SlotTableKt.access$parentAnchors(this.groups, this.groupsSize * 5);
    }

    private final List<Integer> dataIndexes() {
        return SlotTableKt.access$dataAnchors(this.groups, this.groupsSize * 5);
    }

    private final List<Integer> groupSizes() {
        return SlotTableKt.access$groupSizes(this.groups, this.groupsSize * 5);
    }

    @NotNull
    public final List<Object> slotsOf$runtime(int group) {
        int start2 = SlotTableKt.access$dataAnchor(this.groups, group);
        int end2 = group + 1 < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, group + 1) : this.slots.length;
        return ArraysKt.toList(this.slots).subList(start2, end2);
    }

    @Nullable
    public final Object slot$runtime(int group, int slotIndex) {
        int start2 = SlotTableKt.access$slotAnchor(this.groups, group);
        int end2 = group + 1 < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, group + 1) : this.slots.length;
        int len = end2 - start2;
        boolean bl = 0 <= slotIndex ? slotIndex < len : false;
        if (bl) {
            return this.slots[start2 + slotIndex];
        }
        return Composer.Companion.getEmpty();
    }

    @Override
    @NotNull
    public Iterable<CompositionGroup> getCompositionGroups() {
        return this;
    }

    @Override
    @NotNull
    public Iterator<CompositionGroup> iterator() {
        return new GroupIterator(this, 0, this.groupsSize);
    }

    @Override
    @Nullable
    public CompositionGroup find(@NotNull Object identityToFind) {
        Intrinsics.checkNotNullParameter(identityToFind, "identityToFind");
        return new SlotTableGroup(this, 0, 0, 4, null).find(identityToFind);
    }

    private static final void invalidateGroupsWithKey$lambda$16$scanGroup(SlotReader $reader, int $target, List<Anchor> anchors2, Ref.BooleanRef allScopesFound, SlotTable this$0, List<RecomposeScopeImpl> scopes) {
        int key = $reader.getGroupKey();
        if (key == $target || key == -3) {
            if (key != -3) {
                anchors2.add(SlotReader.anchor$default($reader, 0, 1, null));
            }
            if (allScopesFound.element) {
                RecomposeScopeImpl nearestScope = this$0.findEffectiveRecomposeScope($reader.getCurrentGroup());
                if (nearestScope != null) {
                    scopes.add(nearestScope);
                } else {
                    allScopesFound.element = false;
                    scopes.clear();
                }
            }
            $reader.skipGroup();
            return;
        }
        $reader.startGroup();
        while (!$reader.isGroupEnd()) {
            SlotTable.invalidateGroupsWithKey$lambda$16$scanGroup($reader, $target, anchors2, allScopesFound, this$0, scopes);
        }
        $reader.endGroup();
    }

    private static final int verifyWellFormed$validateGroup(Ref.IntRef current, SlotTable this$0, int parent2, int parentEnd) {
        int n = current.element;
        current.element = n + 1;
        int group = n;
        int parentIndex = SlotTableKt.access$parentAnchor(this$0.groups, group);
        if (!(parentIndex == parent2)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$122 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$122 = "Invalid parent index detected at " + group + ", expected parent index to be " + parent2 + " found " + parentIndex;
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$122.toString());
        }
        int end2 = group + SlotTableKt.access$groupSize(this$0.groups, group);
        if (!(end2 <= this$0.groupsSize)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$132 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$132 = "A group extends past the end of the table at " + group;
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$132.toString());
        }
        if (!(end2 <= parentEnd)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$142 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$142 = "A group extends past its parent group at " + group;
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$142.toString());
        }
        int dataStart = SlotTableKt.access$dataAnchor(this$0.groups, group);
        int dataEnd = group >= this$0.groupsSize - 1 ? this$0.slotsSize : SlotTableKt.access$dataAnchor(this$0.groups, group + 1);
        if (!(dataEnd <= this$0.slots.length)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$152 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$152 = "Slots for " + group + " extend past the end of the slot table";
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$152.toString());
        }
        if (!(dataStart <= dataEnd)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$162 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$162 = "Invalid data anchor at " + group;
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$162.toString());
        }
        int slotStart = SlotTableKt.access$slotAnchor(this$0.groups, group);
        if (!(slotStart <= dataEnd)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$172 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$172 = "Slots start out of range at " + group;
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$172.toString());
        }
        int minSlotsNeeded = (SlotTableKt.access$isNode(this$0.groups, group) ? 1 : 0) + (SlotTableKt.access$hasObjectKey(this$0.groups, group) ? 1 : 0) + (SlotTableKt.access$hasAux(this$0.groups, group) ? 1 : 0);
        if (!(dataEnd - dataStart >= minSlotsNeeded)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$182 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$182 = "Not enough slots added for group " + group;
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$182.toString());
        }
        boolean isNode = SlotTableKt.access$isNode(this$0.groups, group);
        if (!(!isNode || this$0.slots[SlotTableKt.access$nodeIndex(this$0.groups, group)] != null)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$192 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$192 = "No node recorded for a node group at " + group;
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$192.toString());
        }
        int nodeCount = 0;
        while (current.element < end2) {
            nodeCount += SlotTable.verifyWellFormed$validateGroup(current, this$0, group, end2);
        }
        int expectedNodeCount = SlotTableKt.access$nodeCount(this$0.groups, group);
        int expectedSlotCount = SlotTableKt.access$groupSize(this$0.groups, group);
        if (!(expectedNodeCount == nodeCount)) {
            boolean bl = false;
            String string = "Incorrect node count detected at " + group + ", expected " + expectedNodeCount + ", received " + nodeCount;
            throw new IllegalStateException(string.toString());
        }
        int actualSlotCount = current.element - group;
        if (!(expectedSlotCount == actualSlotCount)) {
            boolean $i$a$-check-SlotTable$verifyWellFormed$validateGroup$202 = false;
            String $i$a$-check-SlotTable$verifyWellFormed$validateGroup$202 = "Incorrect slot count detected at " + group + ", expected " + expectedSlotCount + ", received " + actualSlotCount;
            throw new IllegalStateException($i$a$-check-SlotTable$verifyWellFormed$validateGroup$202.toString());
        }
        if (SlotTableKt.access$containsAnyMark(this$0.groups, group) && !(group <= 0 || SlotTableKt.access$containsMark(this$0.groups, parent2))) {
            boolean bl = false;
            String string = "Expected group " + parent2 + " to record it contains a mark because " + group + " does";
            throw new IllegalStateException(string.toString());
        }
        return isNode ? 1 : nodeCount;
    }

    private static final void verifyWellFormed$verifySourceGroup(SlotTable this$0, GroupSourceInformation group) {
        block3: {
            ArrayList<Object> arrayList = group.getGroups();
            if (arrayList == null) break block3;
            List $this$fastForEach$iv = arrayList;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object item$iv;
                Object item2 = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                Object e = item2;
                if (e instanceof Anchor) {
                    if (!((Anchor)item2).getValid()) {
                        boolean $i$a$-require-SlotTable$verifyWellFormed$verifySourceGroup$1$32 = false;
                        String $i$a$-require-SlotTable$verifyWellFormed$verifySourceGroup$1$32 = "Source map contains invalid anchor";
                        throw new IllegalArgumentException($i$a$-require-SlotTable$verifyWellFormed$verifySourceGroup$1$32.toString());
                    }
                    if (this$0.ownsAnchor((Anchor)item2)) continue;
                    boolean bl2 = false;
                    String string = "Source map anchor is not owned by the slot table";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(e instanceof GroupSourceInformation)) continue;
                SlotTable.verifyWellFormed$verifySourceGroup(this$0, (GroupSourceInformation)item2);
            }
        }
    }

    private static final int emitGroup$dataIndex(SlotTable this$0, int index2) {
        return index2 >= this$0.groupsSize ? this$0.slotsSize : SlotTableKt.access$dataAnchor(this$0.groups, index2);
    }
}

