/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.layout;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0002\u001a\u000f\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u00a2\u0006\u0002\u0010\b\u001a\u000f\u0010\t\u001a\u00020\u0007*\u00020\u0002\u00a2\u0006\u0002\u0010\b\u001a\u000f\u0010\n\u001a\u00020\u0007*\u00020\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u000b"}, d2={"boundsInParent", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "boundsInRoot", "boundsInWindow", "findRootCoordinates", "positionInParent", "Landroidx/compose/ui/geometry/Offset;", "(Landroidx/compose/ui/layout/LayoutCoordinates;)J", "positionInRoot", "positionInWindow", "ui"})
public final class LayoutCoordinatesKt {
    public static final long positionInRoot(@NotNull LayoutCoordinates $this$positionInRoot) {
        Intrinsics.checkNotNullParameter($this$positionInRoot, "<this>");
        return $this$positionInRoot.localToRoot-MK-Hz9U(Offset.Companion.getZero-F1C5BW0());
    }

    public static final long positionInWindow(@NotNull LayoutCoordinates $this$positionInWindow) {
        Intrinsics.checkNotNullParameter($this$positionInWindow, "<this>");
        return $this$positionInWindow.localToWindow-MK-Hz9U(Offset.Companion.getZero-F1C5BW0());
    }

    @NotNull
    public static final Rect boundsInRoot(@NotNull LayoutCoordinates $this$boundsInRoot) {
        Intrinsics.checkNotNullParameter($this$boundsInRoot, "<this>");
        return LayoutCoordinates.localBoundingBoxOf$default(LayoutCoordinatesKt.findRootCoordinates($this$boundsInRoot), $this$boundsInRoot, false, 2, null);
    }

    @NotNull
    public static final Rect boundsInWindow(@NotNull LayoutCoordinates $this$boundsInWindow) {
        Intrinsics.checkNotNullParameter($this$boundsInWindow, "<this>");
        LayoutCoordinates root = LayoutCoordinatesKt.findRootCoordinates($this$boundsInWindow);
        Rect bounds2 = LayoutCoordinatesKt.boundsInRoot($this$boundsInWindow);
        float rootWidth = IntSize.getWidth-impl(root.getSize-YbymL2g());
        float rootHeight = IntSize.getHeight-impl(root.getSize-YbymL2g());
        float boundsLeft = RangesKt.coerceIn(bounds2.getLeft(), 0.0f, rootWidth);
        float boundsTop = RangesKt.coerceIn(bounds2.getTop(), 0.0f, rootHeight);
        float boundsRight = RangesKt.coerceIn(bounds2.getRight(), 0.0f, rootWidth);
        float boundsBottom = RangesKt.coerceIn(bounds2.getBottom(), 0.0f, rootHeight);
        if (boundsLeft == boundsRight || boundsTop == boundsBottom) {
            return Rect.Companion.getZero();
        }
        long topLeft = root.localToWindow-MK-Hz9U(OffsetKt.Offset(boundsLeft, boundsTop));
        long topRight = root.localToWindow-MK-Hz9U(OffsetKt.Offset(boundsRight, boundsTop));
        long bottomRight = root.localToWindow-MK-Hz9U(OffsetKt.Offset(boundsRight, boundsBottom));
        long bottomLeft = root.localToWindow-MK-Hz9U(OffsetKt.Offset(boundsLeft, boundsBottom));
        float[] fArray = new float[]{Offset.getX-impl(topRight), Offset.getX-impl(bottomLeft), Offset.getX-impl(bottomRight)};
        float left = ComparisonsKt.minOf(Offset.getX-impl(topLeft), fArray);
        float[] fArray2 = new float[]{Offset.getY-impl(topRight), Offset.getY-impl(bottomLeft), Offset.getY-impl(bottomRight)};
        float top = ComparisonsKt.minOf(Offset.getY-impl(topLeft), fArray2);
        float[] fArray3 = new float[]{Offset.getX-impl(topRight), Offset.getX-impl(bottomLeft), Offset.getX-impl(bottomRight)};
        float right = ComparisonsKt.maxOf(Offset.getX-impl(topLeft), fArray3);
        float[] fArray4 = new float[]{Offset.getY-impl(topRight), Offset.getY-impl(bottomLeft), Offset.getY-impl(bottomRight)};
        float bottom = ComparisonsKt.maxOf(Offset.getY-impl(topLeft), fArray4);
        return new Rect(left, top, right, bottom);
    }

    public static final long positionInParent(@NotNull LayoutCoordinates $this$positionInParent) {
        Intrinsics.checkNotNullParameter($this$positionInParent, "<this>");
        LayoutCoordinates layoutCoordinates = $this$positionInParent.getParentLayoutCoordinates();
        return layoutCoordinates != null ? layoutCoordinates.localPositionOf-R5De75A($this$positionInParent, Offset.Companion.getZero-F1C5BW0()) : Offset.Companion.getZero-F1C5BW0();
    }

    @NotNull
    public static final Rect boundsInParent(@NotNull LayoutCoordinates $this$boundsInParent) {
        Intrinsics.checkNotNullParameter($this$boundsInParent, "<this>");
        Object object = $this$boundsInParent.getParentLayoutCoordinates();
        if (object == null || (object = LayoutCoordinates.localBoundingBoxOf$default((LayoutCoordinates)object, $this$boundsInParent, false, 2, null)) == null) {
            object = new Rect(0.0f, 0.0f, IntSize.getWidth-impl($this$boundsInParent.getSize-YbymL2g()), IntSize.getHeight-impl($this$boundsInParent.getSize-YbymL2g()));
        }
        return object;
    }

    @NotNull
    public static final LayoutCoordinates findRootCoordinates(@NotNull LayoutCoordinates $this$findRootCoordinates) {
        Intrinsics.checkNotNullParameter($this$findRootCoordinates, "<this>");
        LayoutCoordinates root = $this$findRootCoordinates;
        LayoutCoordinates parent2 = root.getParentLayoutCoordinates();
        while (parent2 != null) {
            root = parent2;
            parent2 = root.getParentLayoutCoordinates();
        }
        LayoutCoordinates layoutCoordinates = root;
        NodeCoordinator nodeCoordinator = layoutCoordinates instanceof NodeCoordinator ? (NodeCoordinator)layoutCoordinates : null;
        if (nodeCoordinator == null) {
            return root;
        }
        NodeCoordinator rootCoordinator = nodeCoordinator;
        for (NodeCoordinator parentCoordinator = rootCoordinator.getWrappedBy$ui(); parentCoordinator != null; parentCoordinator = parentCoordinator.getWrappedBy$ui()) {
            rootCoordinator = parentCoordinator;
        }
        return rootCoordinator;
    }
}

