/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import java.util.TreeSet;

public final class WordResolver {
    public static final int MAX_WORDS = 8192;
    static final char CHAR_NULL = '\u0000';
    static final int NEGATIVE_OFFSET = 57344;
    static final int MIN_BINARY_SEARCH = 7;
    final char[] mData;
    final String[] mWords;

    WordResolver(String[] words, char[] index2) {
        this.mWords = words;
        this.mData = index2;
    }

    public static WordResolver constructInstance(TreeSet<String> wordSet) {
        if (wordSet.size() > 8192) {
            return null;
        }
        return new Builder(wordSet).construct();
    }

    public int size() {
        return this.mWords.length;
    }

    public String find(char[] str, int start2, int end2) {
        char[] data2 = this.mData;
        if (data2 == null) {
            return this.findFromOne(str, start2, end2);
        }
        int ptr = 0;
        int offset2 = start2;
        block0: do {
            if (offset2 == end2) {
                if (data2[ptr + 1] == '\u0000') {
                    return this.mWords[data2[ptr + 2] - 57344];
                }
                return null;
            }
            char count2 = data2[ptr++];
            char c = str[offset2++];
            if (count2 < '\u0007') {
                if (data2[ptr] == c) {
                    ptr = data2[ptr + 1];
                    continue;
                }
                if (data2[ptr + 2] == c) {
                    ptr = data2[ptr + 3];
                    continue;
                }
                int branchEnd = ptr + (count2 << 1);
                ptr += 4;
                while (ptr < branchEnd) {
                    if (data2[ptr] == c) {
                        ptr = data2[ptr + 1];
                        continue block0;
                    }
                    ptr += 2;
                }
                return null;
            }
            int low = 0;
            int high = count2 - '\u0001';
            while (low <= high) {
                int mid = low + high >> 1;
                int ix = ptr + (mid << 1);
                int diff = data2[ix] - c;
                if (diff > 0) {
                    high = mid - 1;
                    continue;
                }
                if (diff < 0) {
                    low = mid + 1;
                    continue;
                }
                ptr = data2[ix + 1];
                continue block0;
            }
            return null;
        } while (ptr < 57344);
        String word = this.mWords[ptr - 57344];
        int expLen = end2 - start2;
        if (word.length() != expLen) {
            return null;
        }
        int i = offset2 - start2;
        while (offset2 < end2) {
            if (word.charAt(i) != str[offset2]) {
                return null;
            }
            ++i;
            ++offset2;
        }
        return word;
    }

    private String findFromOne(char[] str, int start2, int end2) {
        String word = this.mWords[0];
        int len = end2 - start2;
        if (word.length() != len) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (word.charAt(i) == str[start2 + i]) continue;
            return null;
        }
        return word;
    }

    public String find(String str) {
        char[] data2 = this.mData;
        if (data2 == null) {
            String word = this.mWords[0];
            return word.equals(str) ? word : null;
        }
        int ptr = 0;
        int offset2 = 0;
        int end2 = str.length();
        block0: do {
            if (offset2 == end2) {
                if (data2[ptr + 1] == '\u0000') {
                    return this.mWords[data2[ptr + 2] - 57344];
                }
                return null;
            }
            char count2 = data2[ptr++];
            char c = str.charAt(offset2++);
            if (count2 < '\u0007') {
                if (data2[ptr] == c) {
                    ptr = data2[ptr + 1];
                    continue;
                }
                if (data2[ptr + 2] == c) {
                    ptr = data2[ptr + 3];
                    continue;
                }
                int branchEnd = ptr + (count2 << 1);
                ptr += 4;
                while (ptr < branchEnd) {
                    if (data2[ptr] == c) {
                        ptr = data2[ptr + 1];
                        continue block0;
                    }
                    ptr += 2;
                }
                return null;
            }
            int low = 0;
            int high = count2 - '\u0001';
            while (low <= high) {
                int mid = low + high >> 1;
                int ix = ptr + (mid << 1);
                int diff = data2[ix] - c;
                if (diff > 0) {
                    high = mid - 1;
                    continue;
                }
                if (diff < 0) {
                    low = mid + 1;
                    continue;
                }
                ptr = data2[ix + 1];
                continue block0;
            }
            return null;
        } while (ptr < 57344);
        String word = this.mWords[ptr - 57344];
        if (word.length() != str.length()) {
            return null;
        }
        while (offset2 < end2) {
            if (word.charAt(offset2) != str.charAt(offset2)) {
                return null;
            }
            ++offset2;
        }
        return word;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16 + (this.mWords.length << 3));
        int len = this.mWords.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.mWords[i]);
        }
        return sb.toString();
    }

    private static final class Builder {
        final String[] mWords;
        char[] mData;
        int mSize;

        public Builder(TreeSet<String> wordSet) {
            int wordCount = wordSet.size();
            this.mWords = new String[wordCount];
            wordSet.toArray(this.mWords);
            if (wordCount < 2) {
                if (wordCount == 0) {
                    throw new IllegalArgumentException();
                }
                this.mData = null;
            } else {
                int size2 = wordCount * 6;
                if (size2 < 256) {
                    size2 = 256;
                }
                this.mData = new char[size2];
            }
        }

        public WordResolver construct() {
            char[] result2;
            if (this.mData == null) {
                result2 = null;
            } else {
                this.constructBranch(0, 0, this.mWords.length);
                if (this.mSize > 57344) {
                    return null;
                }
                result2 = new char[this.mSize];
                System.arraycopy(this.mData, 0, result2, 0, this.mSize);
            }
            return new WordResolver(this.mWords, result2);
        }

        private void constructBranch(int charIndex, int start2, int end2) {
            boolean gotRunt;
            if (this.mSize >= this.mData.length) {
                this.expand(1);
            }
            this.mData[this.mSize++] = '\u0000';
            int structStart = this.mSize + 1;
            int groupCount = 0;
            String[] words = this.mWords;
            int groupStart = start2;
            if (words[groupStart].length() == charIndex) {
                if (this.mSize + 2 > this.mData.length) {
                    this.expand(2);
                }
                this.mData[this.mSize++] = '\u0000';
                this.mData[this.mSize++] = (char)(57344 + groupStart);
                ++groupStart;
                ++groupCount;
                gotRunt = true;
            } else {
                gotRunt = false;
            }
            while (groupStart < end2) {
                int j;
                char c = words[groupStart].charAt(charIndex);
                for (j = groupStart + 1; j < end2 && words[j].charAt(charIndex) == c; ++j) {
                }
                if (this.mSize + 2 > this.mData.length) {
                    this.expand(2);
                }
                this.mData[this.mSize++] = c;
                this.mData[this.mSize++] = (char)(j - groupStart);
                groupStart = j;
                ++groupCount;
            }
            this.mData[structStart - 2] = (char)groupCount;
            groupStart = start2;
            if (gotRunt) {
                structStart += 2;
                ++groupStart;
            }
            int structEnd = this.mSize;
            ++charIndex;
            while (structStart < structEnd) {
                groupCount = this.mData[structStart];
                if (groupCount == 1) {
                    this.mData[structStart] = (char)(57344 + groupStart);
                } else {
                    this.mData[structStart] = (char)this.mSize;
                    this.constructBranch(charIndex, groupStart, groupStart + groupCount);
                }
                groupStart += groupCount;
                structStart += 2;
            }
        }

        private char[] expand(int needSpace) {
            int len;
            char[] old = this.mData;
            int newSize = len + ((len = old.length) < 4096 ? len : len >> 1);
            if (newSize < this.mSize + needSpace) {
                newSize = this.mSize + needSpace + 64;
            }
            this.mData = new char[newSize];
            System.arraycopy(old, 0, this.mData, 0, len);
            return this.mData;
        }
    }
}

