/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import java.util.TreeSet;

public final class WordSet {
    static final char CHAR_NULL = '\u0000';
    static final int NEGATIVE_OFFSET = 49152;
    static final int MIN_BINARY_SEARCH = 7;
    final char[] mData;

    private WordSet(char[] data2) {
        this.mData = data2;
    }

    public static WordSet constructSet(TreeSet<String> wordSet) {
        return new WordSet(new Builder(wordSet).construct());
    }

    public static char[] constructRaw(TreeSet<String> wordSet) {
        return new Builder(wordSet).construct();
    }

    public boolean contains(char[] buf, int start2, int end2) {
        return WordSet.contains(this.mData, buf, start2, end2);
    }

    public static boolean contains(char[] data2, char[] str, int start2, int end2) {
        int ptr = 0;
        block0: do {
            char count2;
            int left;
            if ((left = end2 - start2) == 0) {
                return data2[ptr + 1] == '\u0000';
            }
            if ((count2 = data2[ptr++]) >= '\uc000') {
                int expCount = count2 - 49152;
                if (left != expCount) {
                    return false;
                }
                while (start2 < end2) {
                    if (data2[ptr] != str[start2]) {
                        return false;
                    }
                    ++ptr;
                    ++start2;
                }
                return true;
            }
            char c = str[start2++];
            if (count2 < '\u0007') {
                if (data2[ptr] == c) {
                    ptr = data2[ptr + 1];
                    continue;
                }
                if (data2[ptr + 2] == c) {
                    ptr = data2[ptr + 3];
                    continue;
                }
                int branchEnd = ptr + (count2 << 1);
                ptr += 4;
                while (ptr < branchEnd) {
                    if (data2[ptr] == c) {
                        ptr = data2[ptr + 1];
                        continue block0;
                    }
                    ptr += 2;
                }
                return false;
            }
            int low = 0;
            int high = count2 - '\u0001';
            while (low <= high) {
                int mid = low + high >> 1;
                int ix = ptr + (mid << 1);
                int diff = data2[ix] - c;
                if (diff > 0) {
                    high = mid - 1;
                    continue;
                }
                if (diff < 0) {
                    low = mid + 1;
                    continue;
                }
                ptr = data2[ix + 1];
                continue block0;
            }
            return false;
        } while (ptr != 0);
        return start2 == end2;
    }

    public boolean contains(String str) {
        return WordSet.contains(this.mData, str);
    }

    public static boolean contains(char[] data2, String str) {
        int ptr = 0;
        int start2 = 0;
        int end2 = str.length();
        block0: do {
            char count2;
            int left;
            if ((left = end2 - start2) == 0) {
                return data2[ptr + 1] == '\u0000';
            }
            if ((count2 = data2[ptr++]) >= '\uc000') {
                int expCount = count2 - 49152;
                if (left != expCount) {
                    return false;
                }
                while (start2 < end2) {
                    if (data2[ptr] != str.charAt(start2)) {
                        return false;
                    }
                    ++ptr;
                    ++start2;
                }
                return true;
            }
            char c = str.charAt(start2++);
            if (count2 < '\u0007') {
                if (data2[ptr] == c) {
                    ptr = data2[ptr + 1];
                    continue;
                }
                if (data2[ptr + 2] == c) {
                    ptr = data2[ptr + 3];
                    continue;
                }
                int branchEnd = ptr + (count2 << 1);
                ptr += 4;
                while (ptr < branchEnd) {
                    if (data2[ptr] == c) {
                        ptr = data2[ptr + 1];
                        continue block0;
                    }
                    ptr += 2;
                }
                return false;
            }
            int low = 0;
            int high = count2 - '\u0001';
            while (low <= high) {
                int mid = low + high >> 1;
                int ix = ptr + (mid << 1);
                int diff = data2[ix] - c;
                if (diff > 0) {
                    high = mid - 1;
                    continue;
                }
                if (diff < 0) {
                    low = mid + 1;
                    continue;
                }
                ptr = data2[ix + 1];
                continue block0;
            }
            return false;
        } while (ptr != 0);
        return start2 == end2;
    }

    private static final class Builder {
        final String[] mWords;
        char[] mData;
        int mSize;

        public Builder(TreeSet<String> wordSet) {
            int wordCount = wordSet.size();
            this.mWords = new String[wordCount];
            wordSet.toArray(this.mWords);
            int size2 = wordCount * 12;
            if (size2 < 256) {
                size2 = 256;
            }
            this.mData = new char[size2];
        }

        public char[] construct() {
            if (this.mWords.length == 1) {
                this.constructLeaf(0, 0);
            } else {
                this.constructBranch(0, 0, this.mWords.length);
            }
            char[] result2 = new char[this.mSize];
            System.arraycopy(this.mData, 0, result2, 0, this.mSize);
            return result2;
        }

        private void constructBranch(int charIndex, int start2, int end2) {
            if (this.mSize >= this.mData.length) {
                this.expand(1);
            }
            this.mData[this.mSize++] = '\u0000';
            int structStart = this.mSize + 1;
            int groupCount = 0;
            String[] words = this.mWords;
            int groupStart = start2;
            if (words[groupStart].length() == charIndex) {
                if (this.mSize + 2 > this.mData.length) {
                    this.expand(2);
                }
                this.mData[this.mSize++] = '\u0000';
                this.mData[this.mSize++] = '\u0000';
                ++groupStart;
                ++groupCount;
            }
            while (groupStart < end2) {
                int j;
                char c = words[groupStart].charAt(charIndex);
                for (j = groupStart + 1; j < end2 && words[j].charAt(charIndex) == c; ++j) {
                }
                if (this.mSize + 2 > this.mData.length) {
                    this.expand(2);
                }
                this.mData[this.mSize++] = c;
                this.mData[this.mSize++] = (char)(j - groupStart);
                groupStart = j;
                ++groupCount;
            }
            this.mData[structStart - 2] = (char)groupCount;
            groupStart = start2;
            if (this.mData[structStart] == '\u0000') {
                structStart += 2;
                ++groupStart;
            }
            int structEnd = this.mSize;
            ++charIndex;
            while (structStart < structEnd) {
                groupCount = this.mData[structStart];
                this.mData[structStart] = (char)this.mSize;
                if (groupCount == 1) {
                    String word = words[groupStart];
                    if (word.length() == charIndex) {
                        this.mData[structStart] = '\u0000';
                    } else {
                        this.constructLeaf(charIndex, groupStart);
                    }
                } else {
                    this.constructBranch(charIndex, groupStart, groupStart + groupCount);
                }
                groupStart += groupCount;
                structStart += 2;
            }
        }

        private void constructLeaf(int charIndex, int wordIndex) {
            char[] data2;
            String word = this.mWords[wordIndex];
            int len = word.length();
            if (this.mSize + len + 1 >= (data2 = this.mData).length) {
                data2 = this.expand(len + 1);
            }
            data2[this.mSize++] = (char)(49152 + (len - charIndex));
            while (charIndex < len) {
                data2[this.mSize++] = word.charAt(charIndex);
                ++charIndex;
            }
        }

        private char[] expand(int needSpace) {
            int len;
            char[] old = this.mData;
            int newSize = len + ((len = old.length) < 4096 ? len : len >> 1);
            if (newSize < this.mSize + needSpace) {
                newSize = this.mSize + needSpace + 64;
            }
            this.mData = new char[newSize];
            System.arraycopy(old, 0, this.mData, 0, len);
            return this.mData;
        }
    }
}

