/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AnnotatedClassResolver {
    private static final Annotations NO_ANNOTATIONS = AnnotationCollector.emptyAnnotations();
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_ENUM = Enum.class;
    private static final Class<?> CLS_LIST = List.class;
    private static final Class<?> CLS_MAP = Map.class;
    private final MapperConfig<?> _config;
    private final AnnotationIntrospector _intr;
    private final ClassIntrospector.MixInResolver _mixInResolver;
    private final TypeBindings _bindings;
    private final JavaType _type;
    private final Class<?> _class;
    private final Class<?> _primaryMixin;
    private final boolean _collectAnnotations;

    AnnotatedClassResolver(MapperConfig<?> config2, JavaType type2, ClassIntrospector.MixInResolver r) {
        this._config = config2;
        this._type = type2;
        this._class = type2.getRawClass();
        this._mixInResolver = r;
        this._bindings = type2.getBindings();
        this._intr = config2.isAnnotationProcessingEnabled() ? config2.getAnnotationIntrospector() : null;
        this._primaryMixin = r == null ? null : r.findMixInClassFor(this._class);
        this._collectAnnotations = this._intr != null && (!ClassUtil.isJDKClass(this._class) || !this._type.isContainerType());
    }

    AnnotatedClassResolver(MapperConfig<?> config2, Class<?> cls, ClassIntrospector.MixInResolver r) {
        this._config = config2;
        this._type = null;
        this._class = cls;
        this._mixInResolver = r;
        this._bindings = TypeBindings.emptyBindings();
        if (config2 == null) {
            this._intr = null;
            this._primaryMixin = null;
        } else {
            this._intr = config2.isAnnotationProcessingEnabled() ? config2.getAnnotationIntrospector() : null;
            this._primaryMixin = r == null ? null : r.findMixInClassFor(this._class);
        }
        this._collectAnnotations = this._intr != null;
    }

    public static AnnotatedClass resolve(MapperConfig<?> config2, JavaType forType, ClassIntrospector.MixInResolver r) {
        if (forType.isArrayType() && AnnotatedClassResolver.skippableArray(config2, forType.getRawClass())) {
            return AnnotatedClassResolver.createArrayType(config2, forType.getRawClass());
        }
        return new AnnotatedClassResolver(config2, forType, r).resolveFully();
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> config2, Class<?> forType) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(config2, forType, config2);
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> config2, JavaType forType, ClassIntrospector.MixInResolver r) {
        if (forType.isArrayType() && AnnotatedClassResolver.skippableArray(config2, forType.getRawClass())) {
            return AnnotatedClassResolver.createArrayType(config2, forType.getRawClass());
        }
        return new AnnotatedClassResolver(config2, forType, r).resolveWithoutSuperTypes();
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> config2, Class<?> forType, ClassIntrospector.MixInResolver r) {
        if (forType.isArray() && AnnotatedClassResolver.skippableArray(config2, forType)) {
            return AnnotatedClassResolver.createArrayType(config2, forType);
        }
        return new AnnotatedClassResolver(config2, forType, r).resolveWithoutSuperTypes();
    }

    private static boolean skippableArray(MapperConfig<?> config2, Class<?> type2) {
        return config2 == null || config2.findMixInClassFor(type2) == null;
    }

    static AnnotatedClass createPrimordial(Class<?> raw) {
        return new AnnotatedClass(raw);
    }

    static AnnotatedClass createArrayType(MapperConfig<?> config2, Class<?> raw) {
        return new AnnotatedClass(raw);
    }

    AnnotatedClass resolveFully() {
        ArrayList<JavaType> superTypes2 = new ArrayList<JavaType>(8);
        if (!this._type.hasRawClass(Object.class)) {
            if (this._type.isInterface()) {
                AnnotatedClassResolver._addSuperInterfaces(this._type, superTypes2, false);
            } else {
                AnnotatedClassResolver._addSuperTypes(this._type, superTypes2, false);
            }
        }
        return new AnnotatedClass(this._type, this._class, superTypes2, this._primaryMixin, this.resolveClassAnnotations(superTypes2), this._bindings, this._intr, this._mixInResolver, this._config.getTypeFactory(), this._collectAnnotations);
    }

    AnnotatedClass resolveWithoutSuperTypes() {
        List<JavaType> superTypes2 = Collections.emptyList();
        return new AnnotatedClass(null, this._class, superTypes2, this._primaryMixin, this.resolveClassAnnotations(superTypes2), this._bindings, this._intr, this._mixInResolver, this._config.getTypeFactory(), this._collectAnnotations);
    }

    private static void _addSuperTypes(JavaType type2, List<JavaType> result2, boolean addClassItself) {
        Class<?> cls = type2.getRawClass();
        if (cls == CLS_OBJECT || cls == CLS_ENUM) {
            return;
        }
        if (addClassItself) {
            if (AnnotatedClassResolver._contains(result2, cls)) {
                return;
            }
            result2.add(type2);
        }
        for (JavaType intCls : type2.getInterfaces()) {
            AnnotatedClassResolver._addSuperInterfaces(intCls, result2, true);
        }
        JavaType superType = type2.getSuperClass();
        if (superType != null) {
            AnnotatedClassResolver._addSuperTypes(superType, result2, true);
        }
    }

    private static void _addSuperInterfaces(JavaType type2, List<JavaType> result2, boolean addClassItself) {
        Class<?> cls = type2.getRawClass();
        if (addClassItself) {
            if (AnnotatedClassResolver._contains(result2, cls)) {
                return;
            }
            result2.add(type2);
            if (cls == CLS_LIST || cls == CLS_MAP) {
                return;
            }
        }
        for (JavaType intCls : type2.getInterfaces()) {
            AnnotatedClassResolver._addSuperInterfaces(intCls, result2, true);
        }
    }

    private static boolean _contains(List<JavaType> found, Class<?> raw) {
        int end2 = found.size();
        for (int i = 0; i < end2; ++i) {
            if (found.get(i).getRawClass() != raw) continue;
            return true;
        }
        return false;
    }

    private Annotations resolveClassAnnotations(List<JavaType> superTypes2) {
        boolean checkMixIns;
        if (this._intr == null) {
            return NO_ANNOTATIONS;
        }
        boolean bl = checkMixIns = this._mixInResolver != null && (!(this._mixInResolver instanceof SimpleMixInResolver) || ((SimpleMixInResolver)this._mixInResolver).hasMixIns());
        if (!checkMixIns && !this._collectAnnotations) {
            return NO_ANNOTATIONS;
        }
        AnnotationCollector resolvedCA = AnnotationCollector.emptyCollector();
        if (this._primaryMixin != null) {
            resolvedCA = this._addClassMixIns(resolvedCA, this._class, this._primaryMixin);
        }
        if (this._collectAnnotations) {
            resolvedCA = this._addAnnotationsIfNotPresent(resolvedCA, ClassUtil.findClassAnnotations(this._class));
        }
        for (JavaType type2 : superTypes2) {
            if (checkMixIns) {
                Class<?> cls = type2.getRawClass();
                resolvedCA = this._addClassMixIns(resolvedCA, cls, this._mixInResolver.findMixInClassFor(cls));
            }
            if (!this._collectAnnotations) continue;
            resolvedCA = this._addAnnotationsIfNotPresent(resolvedCA, ClassUtil.findClassAnnotations(type2.getRawClass()));
        }
        if (checkMixIns) {
            resolvedCA = this._addClassMixIns(resolvedCA, Object.class, this._mixInResolver.findMixInClassFor(Object.class));
        }
        return resolvedCA.asAnnotations();
    }

    private AnnotationCollector _addClassMixIns(AnnotationCollector annotations2, Class<?> target, Class<?> mixin) {
        if (mixin != null) {
            annotations2 = this._addAnnotationsIfNotPresent(annotations2, ClassUtil.findClassAnnotations(mixin));
            for (Class<?> parent2 : ClassUtil.findSuperClasses(mixin, target, false)) {
                annotations2 = this._addAnnotationsIfNotPresent(annotations2, ClassUtil.findClassAnnotations(parent2));
            }
        }
        return annotations2;
    }

    private AnnotationCollector _addAnnotationsIfNotPresent(AnnotationCollector c, Annotation[] anns) {
        if (anns != null) {
            for (Annotation ann : anns) {
                if (c.isPresent(ann)) continue;
                c = c.addOrOverride(ann);
                if (!this._intr.isAnnotationBundle(ann)) continue;
                c = this._addFromBundleIfNotPresent(c, ann);
            }
        }
        return c;
    }

    private AnnotationCollector _addFromBundleIfNotPresent(AnnotationCollector c, Annotation bundle) {
        for (Annotation ann : ClassUtil.findClassAnnotations(bundle.annotationType())) {
            if (ann instanceof Target || ann instanceof Retention || c.isPresent(ann)) continue;
            c = c.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c = this._addFromBundleIfNotPresent(c, ann);
        }
        return c;
    }
}

