/*
 * Decompiled with CFR 0.152.
 */
package generation.voice;

import generation.VoiceGenerationModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lgeneration/voice/Voice;", "", "generationModel", "Lgeneration/VoiceGenerationModel;", "name", "", "<init>", "(Lgeneration/VoiceGenerationModel;Ljava/lang/String;)V", "getGenerationModel", "()Lgeneration/VoiceGenerationModel;", "getName", "()Ljava/lang/String;", "getExample", "Ljava/io/File;", "getResourceFile", "path", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Generation"})
public final class Voice {
    @NotNull
    private final VoiceGenerationModel generationModel;
    @NotNull
    private final String name;

    public Voice(@NotNull VoiceGenerationModel generationModel, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)generationModel, "generationModel");
        Intrinsics.checkNotNullParameter(name, "name");
        this.generationModel = generationModel;
        this.name = name;
    }

    @NotNull
    public final VoiceGenerationModel getGenerationModel() {
        return this.generationModel;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final File getExample() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.generationModel.ordinal()]) {
            case 1: 
            case 2: {
                File dataFile = new File("data/voices/ElevenLabs/" + this.name + ".mp3");
                if (!dataFile.exists()) {
                    dataFile.getParentFile().mkdirs();
                    InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("voices/ElevenLabs/" + this.name + ".mp3");
                    FileOutputStream out = new FileOutputStream(dataFile);
                    if (inputStream2 != null) {
                        out.write(ByteStreamsKt.readBytes(inputStream2));
                    }
                }
                return dataFile;
            }
            case 3: {
                File dataFile = new File("data/voices/FishSpeech2/" + this.name + ".mp3");
                if (!dataFile.exists()) {
                    dataFile.getParentFile().mkdirs();
                    InputStream inputStream3 = this.getClass().getClassLoader().getResourceAsStream("voices/FishSpeech2/" + this.name + ".mp3");
                    FileOutputStream out = new FileOutputStream(dataFile);
                    if (inputStream3 != null) {
                        out.write(ByteStreamsKt.readBytes(inputStream3));
                    }
                }
                return dataFile;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final File getResourceFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        URL uRL = this.getClass().getClassLoader().getResource(path);
        if (uRL == null) {
            throw new IllegalArgumentException("Resource not found: " + path);
        }
        URL resource2 = uRL;
        return new File(resource2.toURI());
    }

    @NotNull
    public final VoiceGenerationModel component1() {
        return this.generationModel;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Voice copy(@NotNull VoiceGenerationModel generationModel, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)generationModel, "generationModel");
        Intrinsics.checkNotNullParameter(name, "name");
        return new Voice(generationModel, name);
    }

    public static /* synthetic */ Voice copy$default(Voice voice, VoiceGenerationModel voiceGenerationModel, String string, int n, Object object) {
        if ((n & 1) != 0) {
            voiceGenerationModel = voice.generationModel;
        }
        if ((n & 2) != 0) {
            string = voice.name;
        }
        return voice.copy(voiceGenerationModel, string);
    }

    @NotNull
    public String toString() {
        return "Voice(generationModel=" + this.generationModel + ", name=" + this.name + ")";
    }

    public int hashCode() {
        int result2 = this.generationModel.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Voice)) {
            return false;
        }
        Voice voice = (Voice)other;
        if (this.generationModel != voice.generationModel) {
            return false;
        }
        return Intrinsics.areEqual(this.name, voice.name);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VoiceGenerationModel.values().length];
            try {
                nArray[VoiceGenerationModel.ElevenLabsTurbo25.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VoiceGenerationModel.ElevenLabsV3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VoiceGenerationModel.FishSpeech2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

