/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.HeapByteBufUtil;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.Recycler;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    private static final Recycler<PooledHeapByteBuf> RECYCLER = new Recycler<PooledHeapByteBuf>(){

        @Override
        protected PooledHeapByteBuf newObject(Recycler.Handle<PooledHeapByteBuf> handle2) {
            return new PooledHeapByteBuf((ObjectPool.Handle<? extends PooledHeapByteBuf>)handle2, 0);
        }
    };

    static PooledHeapByteBuf newInstance(int maxCapacity) {
        PooledHeapByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    PooledHeapByteBuf(ObjectPool.Handle<? extends PooledHeapByteBuf> recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    protected byte _getByte(int index2) {
        return HeapByteBufUtil.getByte((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return HeapByteBufUtil.getShort((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return HeapByteBufUtil.getShortLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return HeapByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return HeapByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return HeapByteBufUtil.getInt((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return HeapByteBufUtil.getIntLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return HeapByteBufUtil.getLong((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return HeapByteBufUtil.getLongLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    public final ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress() && PlatformDependent.hasUnsafe()) {
            PlatformDependent.copyMemory((byte[])this.memory, this.idx(index2), dst.memoryAddress() + (long)dstIndex, (long)length);
        } else if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            dst.setBytes(dstIndex, (byte[])this.memory, this.idx(index2), length);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.length);
        System.arraycopy(this.memory, this.idx(index2), dst, dstIndex, length);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, ByteBuffer dst) {
        int length = dst.remaining();
        this.checkIndex(index2, length);
        dst.put((byte[])this.memory, this.idx(index2), length);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.checkIndex(index2, length);
        out.write((byte[])this.memory, this.idx(index2), length);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value) {
        HeapByteBufUtil.setByte((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setShort(int index2, int value) {
        HeapByteBufUtil.setShort((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        HeapByteBufUtil.setShortLE((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setMedium(int index2, int value) {
        HeapByteBufUtil.setMedium((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        HeapByteBufUtil.setMediumLE((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setInt(int index2, int value) {
        HeapByteBufUtil.setInt((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        HeapByteBufUtil.setIntLE((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setLong(int index2, long value) {
        HeapByteBufUtil.setLong((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        HeapByteBufUtil.setLongLE((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    public final ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index2, length, srcIndex, src.capacity());
        if (src.hasMemoryAddress() && PlatformDependent.hasUnsafe()) {
            PlatformDependent.copyMemory(src.memoryAddress() + (long)srcIndex, (byte[])this.memory, this.idx(index2), (long)length);
        } else if (src.hasArray()) {
            this.setBytes(index2, src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            src.getBytes(srcIndex, (byte[])this.memory, this.idx(index2), length);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.checkSrcIndex(index2, length, srcIndex, src.length);
        System.arraycopy(src, srcIndex, this.memory, this.idx(index2), length);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int index2, ByteBuffer src) {
        int length = src.remaining();
        this.checkIndex(index2, length);
        src.get((byte[])this.memory, this.idx(index2), length);
        return this;
    }

    @Override
    public final int setBytes(int index2, InputStream in, int length) throws IOException {
        this.checkIndex(index2, length);
        return in.read((byte[])this.memory, this.idx(index2), length);
    }

    @Override
    public final ByteBuf copy(int index2, int length) {
        this.checkIndex(index2, length);
        ByteBuf copy2 = this.alloc().heapBuffer(length, this.maxCapacity());
        return copy2.writeBytes((byte[])this.memory, this.idx(index2), length);
    }

    @Override
    final ByteBuffer duplicateInternalNioBuffer(int index2, int length) {
        this.checkIndex(index2, length);
        return ByteBuffer.wrap((byte[])this.memory, this.idx(index2), length).slice();
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        this.ensureAccessible();
        return (byte[])this.memory;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(byte[] memory) {
        return ByteBuffer.wrap(memory);
    }
}

