/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.Map;

public final class AsciiHeadersEncoder {
    private final ByteBuf buf;
    private final SeparatorType separatorType;
    private final NewlineType newlineType;

    public AsciiHeadersEncoder(ByteBuf buf) {
        this(buf, SeparatorType.COLON_SPACE, NewlineType.CRLF);
    }

    public AsciiHeadersEncoder(ByteBuf buf, SeparatorType separatorType, NewlineType newlineType) {
        this.buf = ObjectUtil.checkNotNull(buf, "buf");
        this.separatorType = ObjectUtil.checkNotNull(separatorType, "separatorType");
        this.newlineType = ObjectUtil.checkNotNull(newlineType, "newlineType");
    }

    public void encode(Map.Entry<CharSequence, CharSequence> entry) {
        CharSequence name = entry.getKey();
        CharSequence value = entry.getValue();
        ByteBuf buf = this.buf;
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        int offset2 = buf.writerIndex();
        buf.ensureWritable(entryLen);
        AsciiHeadersEncoder.writeAscii(buf, offset2, name);
        offset2 += nameLen;
        switch (this.separatorType) {
            case COLON: {
                buf.setByte(offset2++, 58);
                break;
            }
            case COLON_SPACE: {
                buf.setByte(offset2++, 58);
                buf.setByte(offset2++, 32);
                break;
            }
            default: {
                throw new Error("Unexpected separator type: " + (Object)((Object)this.separatorType));
            }
        }
        AsciiHeadersEncoder.writeAscii(buf, offset2, value);
        offset2 += valueLen;
        switch (this.newlineType) {
            case LF: {
                buf.setByte(offset2++, 10);
                break;
            }
            case CRLF: {
                buf.setByte(offset2++, 13);
                buf.setByte(offset2++, 10);
                break;
            }
            default: {
                throw new Error("Unexpected newline type: " + (Object)((Object)this.newlineType));
            }
        }
        buf.writerIndex(offset2);
    }

    private static void writeAscii(ByteBuf buf, int offset2, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value, 0, buf, offset2, value.length());
        } else {
            buf.setCharSequence(offset2, value, CharsetUtil.US_ASCII);
        }
    }

    public static enum NewlineType {
        LF,
        CRLF;

    }

    public static enum SeparatorType {
        COLON,
        COLON_SPACE;

    }
}

