/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;

class Bzip2BitReader {
    private static final int MAX_COUNT_OF_READABLE_BYTES = 0xFFFFFFF;
    private ByteBuf in;
    private long bitBuffer;
    private int bitCount;

    Bzip2BitReader() {
    }

    void setByteBuf(ByteBuf in) {
        this.in = in;
    }

    int readBits(int count2) {
        if (count2 < 0 || count2 > 32) {
            throw new IllegalArgumentException("count: " + count2 + " (expected: 0-32 )");
        }
        int bitCount = this.bitCount;
        long bitBuffer = this.bitBuffer;
        if (bitCount < count2) {
            int offset2;
            long readData;
            switch (this.in.readableBytes()) {
                case 1: {
                    readData = this.in.readUnsignedByte();
                    offset2 = 8;
                    break;
                }
                case 2: {
                    readData = this.in.readUnsignedShort();
                    offset2 = 16;
                    break;
                }
                case 3: {
                    readData = this.in.readUnsignedMedium();
                    offset2 = 24;
                    break;
                }
                default: {
                    readData = this.in.readUnsignedInt();
                    offset2 = 32;
                }
            }
            bitBuffer = bitBuffer << offset2 | readData;
            bitCount += offset2;
            this.bitBuffer = bitBuffer;
        }
        this.bitCount = bitCount -= count2;
        return (int)(bitBuffer >>> bitCount & (count2 != 32 ? (long)((1 << count2) - 1) : 0xFFFFFFFFL));
    }

    boolean readBoolean() {
        return this.readBits(1) != 0;
    }

    int readInt() {
        return this.readBits(32);
    }

    void refill() {
        short readData = this.in.readUnsignedByte();
        this.bitBuffer = this.bitBuffer << 8 | (long)readData;
        this.bitCount += 8;
    }

    boolean isReadable() {
        return this.bitCount > 0 || this.in.isReadable();
    }

    boolean hasReadableBits(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("count: " + count2 + " (expected value greater than 0)");
        }
        return this.bitCount >= count2 || (this.in.readableBytes() << 3 & Integer.MAX_VALUE) >= count2 - this.bitCount;
    }

    boolean hasReadableBytes(int count2) {
        if (count2 < 0 || count2 > 0xFFFFFFF) {
            throw new IllegalArgumentException("count: " + count2 + " (expected: 0-" + 0xFFFFFFF + ')');
        }
        return this.hasReadableBits(count2 << 3);
    }
}

