/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordDecoder;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

abstract class DnsResponseDecoder<A extends SocketAddress> {
    private final DnsRecordDecoder recordDecoder;

    DnsResponseDecoder(DnsRecordDecoder recordDecoder) {
        this.recordDecoder = ObjectUtil.checkNotNull(recordDecoder, "recordDecoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DnsResponse decode(A sender, A recipient, ByteBuf buffer) throws Exception {
        int id = buffer.readUnsignedShort();
        int flags = buffer.readUnsignedShort();
        if (flags >> 15 == 0) {
            throw new CorruptedFrameException("not a response");
        }
        DnsResponse response2 = this.newResponse(sender, recipient, id, DnsOpCode.valueOf((byte)(flags >> 11 & 0xF)), DnsResponseCode.valueOf((byte)(flags & 0xF)));
        response2.setRecursionDesired((flags >> 8 & 1) == 1);
        response2.setAuthoritativeAnswer((flags >> 10 & 1) == 1);
        response2.setTruncated((flags >> 9 & 1) == 1);
        response2.setRecursionAvailable((flags >> 7 & 1) == 1);
        response2.setZ(flags >> 4 & 7);
        boolean success2 = false;
        try {
            int questionCount = buffer.readUnsignedShort();
            int answerCount = buffer.readUnsignedShort();
            int authorityRecordCount = buffer.readUnsignedShort();
            int additionalRecordCount = buffer.readUnsignedShort();
            this.decodeQuestions(response2, buffer, questionCount);
            if (!this.decodeRecords(response2, DnsSection.ANSWER, buffer, answerCount)) {
                success2 = true;
                DnsResponse dnsResponse = response2;
                return dnsResponse;
            }
            if (!this.decodeRecords(response2, DnsSection.AUTHORITY, buffer, authorityRecordCount)) {
                success2 = true;
                DnsResponse dnsResponse = response2;
                return dnsResponse;
            }
            this.decodeRecords(response2, DnsSection.ADDITIONAL, buffer, additionalRecordCount);
            success2 = true;
            DnsResponse dnsResponse = response2;
            return dnsResponse;
        }
        finally {
            if (!success2) {
                response2.release();
            }
        }
    }

    protected abstract DnsResponse newResponse(A var1, A var2, int var3, DnsOpCode var4, DnsResponseCode var5) throws Exception;

    private void decodeQuestions(DnsResponse response2, ByteBuf buf, int questionCount) throws Exception {
        for (int i = questionCount; i > 0; --i) {
            response2.addRecord(DnsSection.QUESTION, this.recordDecoder.decodeQuestion(buf));
        }
    }

    private boolean decodeRecords(DnsResponse response2, DnsSection section, ByteBuf buf, int count2) throws Exception {
        for (int i = count2; i > 0; --i) {
            Object r = this.recordDecoder.decodeRecord(buf);
            if (r == null) {
                return false;
            }
            response2.addRecord(section, (DnsRecord)r);
        }
        return true;
    }
}

