/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.Set;

public class SpdyFrameEncoder {
    private final int version;

    public SpdyFrameEncoder(SpdyVersion spdyVersion) {
        this.version = ObjectUtil.checkNotNull(spdyVersion, "spdyVersion").version();
    }

    protected void writeControlFrameHeader(ByteBuf buffer, int type2, byte flags, int length) {
        buffer.writeShort(this.version | 0x8000);
        buffer.writeShort(type2);
        buffer.writeByte(flags);
        buffer.writeMedium(length);
    }

    public ByteBuf encodeDataFrame(ByteBufAllocator allocator, int streamId, boolean last2, ByteBuf data2) {
        int flags = last2 ? 1 : 0;
        int length = data2.readableBytes();
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        frame2.writeInt(streamId & Integer.MAX_VALUE);
        frame2.writeByte(flags);
        frame2.writeMedium(length);
        frame2.writeBytes(data2, data2.readerIndex(), length);
        return frame2;
    }

    public ByteBuf encodeSynStreamFrame(ByteBufAllocator allocator, int streamId, int associatedToStreamId, byte priority, boolean last2, boolean unidirectional, ByteBuf headerBlock) {
        byte flags;
        int headerBlockLength = headerBlock.readableBytes();
        byte by = flags = last2 ? (byte)1 : 0;
        if (unidirectional) {
            flags = (byte)(flags | 2);
        }
        int length = 10 + headerBlockLength;
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, 1, flags, length);
        frame2.writeInt(streamId);
        frame2.writeInt(associatedToStreamId);
        frame2.writeShort((priority & 0xFF) << 13);
        frame2.writeBytes(headerBlock, headerBlock.readerIndex(), headerBlockLength);
        return frame2;
    }

    public ByteBuf encodeSynReplyFrame(ByteBufAllocator allocator, int streamId, boolean last2, ByteBuf headerBlock) {
        int headerBlockLength = headerBlock.readableBytes();
        byte flags = last2 ? (byte)1 : 0;
        int length = 4 + headerBlockLength;
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, 2, flags, length);
        frame2.writeInt(streamId);
        frame2.writeBytes(headerBlock, headerBlock.readerIndex(), headerBlockLength);
        return frame2;
    }

    public ByteBuf encodeRstStreamFrame(ByteBufAllocator allocator, int streamId, int statusCode) {
        byte flags = 0;
        int length = 8;
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, 3, flags, length);
        frame2.writeInt(streamId);
        frame2.writeInt(statusCode);
        return frame2;
    }

    public ByteBuf encodeSettingsFrame(ByteBufAllocator allocator, SpdySettingsFrame spdySettingsFrame) {
        Set<Integer> ids = spdySettingsFrame.ids();
        int numSettings = ids.size();
        byte flags = spdySettingsFrame.clearPreviouslyPersistedSettings() ? (byte)1 : 0;
        int length = 4 + 8 * numSettings;
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, 4, flags, length);
        frame2.writeInt(numSettings);
        for (Integer id : ids) {
            flags = 0;
            if (spdySettingsFrame.isPersistValue(id)) {
                flags = (byte)(flags | 1);
            }
            if (spdySettingsFrame.isPersisted(id)) {
                flags = (byte)(flags | 2);
            }
            frame2.writeByte(flags);
            frame2.writeMedium(id);
            frame2.writeInt(spdySettingsFrame.getValue(id));
        }
        return frame2;
    }

    public ByteBuf encodePingFrame(ByteBufAllocator allocator, int id) {
        byte flags = 0;
        int length = 4;
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, 6, flags, length);
        frame2.writeInt(id);
        return frame2;
    }

    public ByteBuf encodeGoAwayFrame(ByteBufAllocator allocator, int lastGoodStreamId, int statusCode) {
        byte flags = 0;
        int length = 8;
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, 7, flags, length);
        frame2.writeInt(lastGoodStreamId);
        frame2.writeInt(statusCode);
        return frame2;
    }

    public ByteBuf encodeHeadersFrame(ByteBufAllocator allocator, int streamId, boolean last2, ByteBuf headerBlock) {
        int headerBlockLength = headerBlock.readableBytes();
        byte flags = last2 ? (byte)1 : 0;
        int length = 4 + headerBlockLength;
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, 8, flags, length);
        frame2.writeInt(streamId);
        frame2.writeBytes(headerBlock, headerBlock.readerIndex(), headerBlockLength);
        return frame2;
    }

    public ByteBuf encodeWindowUpdateFrame(ByteBufAllocator allocator, int streamId, int deltaWindowSize) {
        byte flags = 0;
        int length = 8;
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, 9, flags, length);
        frame2.writeInt(streamId);
        frame2.writeInt(deltaWindowSize);
        return frame2;
    }

    public ByteBuf encodeUnknownFrame(ByteBufAllocator allocator, int frameType, byte flags, ByteBuf data2) {
        int length = data2.readableBytes();
        ByteBuf frame2 = allocator.ioBuffer(8 + length).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(frame2, frameType, flags, length);
        if (length > 0) {
            frame2.writeBytes(data2, data2.readerIndex(), length);
        }
        return frame2;
    }
}

