/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SWARUtil;

final class AsciiStringUtil {
    static AsciiString toLowerCase(AsciiString string) {
        int length;
        int offset2;
        byte[] byteArray = string.array();
        if (!AsciiStringUtil.containsUpperCase(byteArray, offset2 = string.arrayOffset(), length = string.length())) {
            return string;
        }
        byte[] newByteArray = PlatformDependent.allocateUninitializedArray(length);
        AsciiStringUtil.toLowerCase(byteArray, offset2, newByteArray);
        return new AsciiString(newByteArray, false);
    }

    private static boolean containsUpperCase(byte[] byteArray, int offset2, int length) {
        if (!PlatformDependent.isUnaligned()) {
            return AsciiStringUtil.linearContainsUpperCase(byteArray, offset2, length);
        }
        int longCount = length >>> 3;
        for (int i = 0; i < longCount; ++i) {
            long word = PlatformDependent.getLong(byteArray, offset2);
            if (SWARUtil.containsUpperCase(word)) {
                return true;
            }
            offset2 += 8;
        }
        return AsciiStringUtil.unrolledContainsUpperCase(byteArray, offset2, length & 7);
    }

    private static boolean linearContainsUpperCase(byte[] byteArray, int offset2, int length) {
        int end2 = offset2 + length;
        for (int idx = offset2; idx < end2; ++idx) {
            if (!AsciiStringUtil.isUpperCase(byteArray[idx])) continue;
            return true;
        }
        return false;
    }

    private static boolean unrolledContainsUpperCase(byte[] byteArray, int offset2, int byteCount) {
        assert (byteCount >= 0 && byteCount < 8);
        if ((byteCount & 4) != 0) {
            int word = PlatformDependent.getInt(byteArray, offset2);
            if (SWARUtil.containsUpperCase(word)) {
                return true;
            }
            offset2 += 4;
        }
        if ((byteCount & 2) != 0) {
            if (AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byteArray, offset2))) {
                return true;
            }
            if (AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byteArray, offset2 + 1))) {
                return true;
            }
            offset2 += 2;
        }
        if ((byteCount & 1) != 0) {
            return AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byteArray, offset2));
        }
        return false;
    }

    private static void toLowerCase(byte[] src, int srcOffset, byte[] dst) {
        if (!PlatformDependent.isUnaligned()) {
            AsciiStringUtil.linearToLowerCase(src, srcOffset, dst);
            return;
        }
        int length = dst.length;
        int longCount = length >>> 3;
        int offset2 = 0;
        for (int i = 0; i < longCount; ++i) {
            long word = PlatformDependent.getLong(src, srcOffset + offset2);
            PlatformDependent.putLong(dst, offset2, SWARUtil.toLowerCase(word));
            offset2 += 8;
        }
        AsciiStringUtil.unrolledToLowerCase(src, srcOffset + offset2, dst, offset2, length & 7);
    }

    private static void linearToLowerCase(byte[] src, int srcOffset, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = AsciiStringUtil.toLowerCase(src[srcOffset + i]);
        }
    }

    private static void unrolledToLowerCase(byte[] src, int srcPos, byte[] dst, int dstOffset, int byteCount) {
        int word;
        assert (byteCount >= 0 && byteCount < 8);
        int offset2 = 0;
        if ((byteCount & 4) != 0) {
            word = PlatformDependent.getInt(src, srcPos + offset2);
            PlatformDependent.putInt(dst, dstOffset + offset2, SWARUtil.toLowerCase(word));
            offset2 += 4;
        }
        if ((byteCount & 2) != 0) {
            word = PlatformDependent.getShort(src, srcPos + offset2);
            short result2 = (short)(AsciiStringUtil.toLowerCase((byte)(word >>> 8)) << 8 | AsciiStringUtil.toLowerCase((byte)word));
            PlatformDependent.putShort(dst, dstOffset + offset2, result2);
            offset2 += 2;
        }
        if ((byteCount & 1) != 0) {
            PlatformDependent.putByte(dst, dstOffset + offset2, AsciiStringUtil.toLowerCase(PlatformDependent.getByte(src, srcPos + offset2)));
        }
    }

    static AsciiString toUpperCase(AsciiString string) {
        int length;
        int offset2;
        byte[] byteArray = string.array();
        if (!AsciiStringUtil.containsLowerCase(byteArray, offset2 = string.arrayOffset(), length = string.length())) {
            return string;
        }
        byte[] newByteArray = PlatformDependent.allocateUninitializedArray(length);
        AsciiStringUtil.toUpperCase(byteArray, offset2, newByteArray);
        return new AsciiString(newByteArray, false);
    }

    private static boolean containsLowerCase(byte[] byteArray, int offset2, int length) {
        if (!PlatformDependent.isUnaligned()) {
            return AsciiStringUtil.linearContainsLowerCase(byteArray, offset2, length);
        }
        int longCount = length >>> 3;
        for (int i = 0; i < longCount; ++i) {
            long word = PlatformDependent.getLong(byteArray, offset2);
            if (SWARUtil.containsLowerCase(word)) {
                return true;
            }
            offset2 += 8;
        }
        return AsciiStringUtil.unrolledContainsLowerCase(byteArray, offset2, length & 7);
    }

    private static boolean linearContainsLowerCase(byte[] byteArray, int offset2, int length) {
        int end2 = offset2 + length;
        for (int idx = offset2; idx < end2; ++idx) {
            if (!AsciiStringUtil.isLowerCase(byteArray[idx])) continue;
            return true;
        }
        return false;
    }

    private static boolean unrolledContainsLowerCase(byte[] byteArray, int offset2, int byteCount) {
        assert (byteCount >= 0 && byteCount < 8);
        if ((byteCount & 4) != 0) {
            int word = PlatformDependent.getInt(byteArray, offset2);
            if (SWARUtil.containsLowerCase(word)) {
                return true;
            }
            offset2 += 4;
        }
        if ((byteCount & 2) != 0) {
            if (AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byteArray, offset2))) {
                return true;
            }
            if (AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byteArray, offset2 + 1))) {
                return true;
            }
            offset2 += 2;
        }
        if ((byteCount & 1) != 0) {
            return AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byteArray, offset2));
        }
        return false;
    }

    private static void toUpperCase(byte[] src, int srcOffset, byte[] dst) {
        if (!PlatformDependent.isUnaligned()) {
            AsciiStringUtil.linearToUpperCase(src, srcOffset, dst);
            return;
        }
        int length = dst.length;
        int longCount = length >>> 3;
        int offset2 = 0;
        for (int i = 0; i < longCount; ++i) {
            long word = PlatformDependent.getLong(src, srcOffset + offset2);
            PlatformDependent.putLong(dst, offset2, SWARUtil.toUpperCase(word));
            offset2 += 8;
        }
        AsciiStringUtil.unrolledToUpperCase(src, srcOffset + offset2, dst, offset2, length & 7);
    }

    private static void linearToUpperCase(byte[] src, int srcOffset, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = AsciiStringUtil.toUpperCase(src[srcOffset + i]);
        }
    }

    private static void unrolledToUpperCase(byte[] src, int srcOffset, byte[] dst, int dstOffset, int byteCount) {
        int word;
        assert (byteCount >= 0 && byteCount < 8);
        int offset2 = 0;
        if ((byteCount & 4) != 0) {
            word = PlatformDependent.getInt(src, srcOffset + offset2);
            PlatformDependent.putInt(dst, dstOffset + offset2, SWARUtil.toUpperCase(word));
            offset2 += 4;
        }
        if ((byteCount & 2) != 0) {
            word = PlatformDependent.getShort(src, srcOffset + offset2);
            short result2 = (short)(AsciiStringUtil.toUpperCase((byte)(word >>> 8)) << 8 | AsciiStringUtil.toUpperCase((byte)word));
            PlatformDependent.putShort(dst, dstOffset + offset2, result2);
            offset2 += 2;
        }
        if ((byteCount & 1) != 0) {
            PlatformDependent.putByte(dst, dstOffset + offset2, AsciiStringUtil.toUpperCase(PlatformDependent.getByte(src, srcOffset + offset2)));
        }
    }

    private static boolean isLowerCase(byte value) {
        return value >= 97 && value <= 122;
    }

    static boolean isUpperCase(byte value) {
        return value >= 65 && value <= 90;
    }

    static byte toLowerCase(byte value) {
        return AsciiStringUtil.isUpperCase(value) ? (byte)(value + 32) : value;
    }

    static byte toUpperCase(byte value) {
        return AsciiStringUtil.isLowerCase(value) ? (byte)(value - 32) : value;
    }

    private AsciiStringUtil() {
    }
}

