/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.tracing.TracingOptions;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class VertxOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, VertxOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "eventLoopPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setEventLoopPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "workerPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWorkerPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "blockedThreadCheckInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBlockedThreadCheckInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxEventLoopExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxEventLoopExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxWorkerExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWorkerExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "internalBlockingPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setInternalBlockingPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "haEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHAEnabled((Boolean)member.getValue());
                    break;
                }
                case "quorumSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setQuorumSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "haGroup": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHAGroup((String)member.getValue());
                    break;
                }
                case "metricsOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setMetricsOptions(new MetricsOptions((JsonObject)member.getValue()));
                    break;
                }
                case "fileSystemOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setFileSystemOptions(new FileSystemOptions((JsonObject)member.getValue()));
                    break;
                }
                case "warningExceptionTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWarningExceptionTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "eventBusOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setEventBusOptions(new EventBusOptions((JsonObject)member.getValue()));
                    break;
                }
                case "addressResolverOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setAddressResolverOptions(new AddressResolverOptions((JsonObject)member.getValue()));
                    break;
                }
                case "preferNativeTransport": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPreferNativeTransport((Boolean)member.getValue());
                    break;
                }
                case "maxEventLoopExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMaxEventLoopExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "maxWorkerExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMaxWorkerExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "warningExceptionTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setWarningExceptionTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "blockedThreadCheckIntervalUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBlockedThreadCheckIntervalUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "tracingOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setTracingOptions(new TracingOptions((JsonObject)member.getValue()));
                    break;
                }
                case "disableTCCL": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDisableTCCL((Boolean)member.getValue());
                    break;
                }
                case "useDaemonThread": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseDaemonThread((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(VertxOptions obj, JsonObject json2) {
        VertxOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(VertxOptions obj, Map<String, Object> json2) {
        json2.put("eventLoopPoolSize", obj.getEventLoopPoolSize());
        json2.put("workerPoolSize", obj.getWorkerPoolSize());
        json2.put("blockedThreadCheckInterval", obj.getBlockedThreadCheckInterval());
        json2.put("maxEventLoopExecuteTime", obj.getMaxEventLoopExecuteTime());
        json2.put("maxWorkerExecuteTime", obj.getMaxWorkerExecuteTime());
        json2.put("internalBlockingPoolSize", obj.getInternalBlockingPoolSize());
        json2.put("haEnabled", obj.isHAEnabled());
        json2.put("quorumSize", obj.getQuorumSize());
        if (obj.getHAGroup() != null) {
            json2.put("haGroup", obj.getHAGroup());
        }
        if (obj.getMetricsOptions() != null) {
            json2.put("metricsOptions", obj.getMetricsOptions().toJson());
        }
        if (obj.getFileSystemOptions() != null) {
            json2.put("fileSystemOptions", obj.getFileSystemOptions().toJson());
        }
        json2.put("warningExceptionTime", obj.getWarningExceptionTime());
        if (obj.getEventBusOptions() != null) {
            json2.put("eventBusOptions", obj.getEventBusOptions().toJson());
        }
        if (obj.getAddressResolverOptions() != null) {
            json2.put("addressResolverOptions", obj.getAddressResolverOptions().toJson());
        }
        json2.put("preferNativeTransport", obj.getPreferNativeTransport());
        if (obj.getMaxEventLoopExecuteTimeUnit() != null) {
            json2.put("maxEventLoopExecuteTimeUnit", obj.getMaxEventLoopExecuteTimeUnit().name());
        }
        if (obj.getMaxWorkerExecuteTimeUnit() != null) {
            json2.put("maxWorkerExecuteTimeUnit", obj.getMaxWorkerExecuteTimeUnit().name());
        }
        if (obj.getWarningExceptionTimeUnit() != null) {
            json2.put("warningExceptionTimeUnit", obj.getWarningExceptionTimeUnit().name());
        }
        if (obj.getBlockedThreadCheckIntervalUnit() != null) {
            json2.put("blockedThreadCheckIntervalUnit", obj.getBlockedThreadCheckIntervalUnit().name());
        }
        if (obj.getTracingOptions() != null) {
            json2.put("tracingOptions", obj.getTracingOptions().toJson());
        }
        json2.put("disableTCCL", obj.getDisableTCCL());
        if (obj.getUseDaemonThread() != null) {
            json2.put("useDaemonThread", obj.getUseDaemonThread());
        }
    }
}

