/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Map;
import java.util.Objects;

@DataObject
public class DeliveryOptions {
    public static final long DEFAULT_TIMEOUT = 30000L;
    public static final boolean DEFAULT_LOCAL_ONLY = false;
    public static final TracingPolicy DEFAULT_TRACING_POLICY = TracingPolicy.PROPAGATE;
    private long timeout = 30000L;
    private String codecName;
    private MultiMap headers;
    private boolean localOnly = false;
    private TracingPolicy tracingPolicy = DEFAULT_TRACING_POLICY;

    public DeliveryOptions() {
    }

    public DeliveryOptions(DeliveryOptions other) {
        this.timeout = other.getSendTimeout();
        this.codecName = other.getCodecName();
        if (other.getHeaders() != null) {
            this.headers = MultiMap.caseInsensitiveMultiMap().addAll(other.getHeaders());
        }
        this.localOnly = other.localOnly;
        this.tracingPolicy = other.tracingPolicy;
    }

    public DeliveryOptions(JsonObject json2) {
        this.timeout = json2.getLong("timeout", 30000L);
        this.codecName = json2.getString("codecName", null);
        JsonObject hdrs = json2.getJsonObject("headers", null);
        if (hdrs != null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
            for (Map.Entry<String, Object> entry : hdrs) {
                if (!(entry.getValue() instanceof String)) {
                    throw new IllegalStateException("Invalid type for message header value " + String.valueOf(entry.getValue().getClass()));
                }
                this.headers.set(entry.getKey(), (String)entry.getValue());
            }
        }
        this.localOnly = json2.getBoolean("localOnly", false);
        String tracingPolicyStr = json2.getString("tracingPolicy");
        this.tracingPolicy = tracingPolicyStr != null ? TracingPolicy.valueOf(tracingPolicyStr) : DEFAULT_TRACING_POLICY;
    }

    public JsonObject toJson() {
        JsonObject json2 = new JsonObject();
        json2.put("timeout", this.timeout);
        if (this.codecName != null) {
            json2.put("codecName", this.codecName);
        }
        if (this.headers != null) {
            JsonObject hJson = new JsonObject();
            this.headers.entries().forEach(entry -> hJson.put((String)entry.getKey(), entry.getValue()));
            json2.put("headers", hJson);
        }
        json2.put("localOnly", this.localOnly);
        if (this.tracingPolicy != null) {
            json2.put("tracingPolicy", this.tracingPolicy.name());
        }
        return json2;
    }

    public long getSendTimeout() {
        return this.timeout;
    }

    public DeliveryOptions setSendTimeout(long timeout2) {
        Arguments.require(timeout2 >= 1L, "sendTimeout must be >= 1");
        this.timeout = timeout2;
        return this;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public DeliveryOptions setCodecName(String codecName) {
        this.codecName = codecName;
        return this;
    }

    public DeliveryOptions addHeader(String key, String value) {
        this.checkHeaders();
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    @GenIgnore
    public DeliveryOptions setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    private void checkHeaders() {
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public DeliveryOptions setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
        return this;
    }

    public TracingPolicy getTracingPolicy() {
        return this.tracingPolicy;
    }

    public DeliveryOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        this.tracingPolicy = tracingPolicy;
        return this;
    }
}

