/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.internal.ContextInternal;
import java.util.Objects;

public class HandlerHolder<T> {
    public final ContextInternal context;
    public final HandlerRegistration<T> handler;
    public final boolean localOnly;
    private boolean removed;

    public HandlerHolder(HandlerRegistration<T> handler, boolean localOnly, ContextInternal context2) {
        this.context = context2;
        this.handler = handler;
        this.localOnly = localOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setRemoved() {
        boolean unregistered = false;
        HandlerHolder handlerHolder = this;
        synchronized (handlerHolder) {
            if (!this.removed) {
                this.removed = true;
                unregistered = true;
            }
        }
        return unregistered;
    }

    public synchronized boolean isRemoved() {
        return this.removed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlerHolder that = (HandlerHolder)o;
        return Objects.equals(this.handler, that.handler);
    }

    public int hashCode() {
        return Objects.hashCode(this.handler);
    }

    public long getSeq() {
        return 0L;
    }

    public ContextInternal getContext() {
        return this.context;
    }

    public HandlerRegistration<T> getHandler() {
        return this.handler;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }
}

