/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.net.NetSocket;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.spi.metrics.EventBusMetrics;

final class InboundConnection
implements Handler<Buffer> {
    private static final Buffer PONG = Buffer.buffer(new byte[]{1});
    private final ClusteredEventBus clusteredEventBus;
    private final NetSocket socket;
    private final RecordParser parser;
    private int size = -1;
    private Handler<ClusteredMessage<?, ?>> handler;

    public InboundConnection(ClusteredEventBus clusteredEventBus, NetSocket socket) {
        this.clusteredEventBus = clusteredEventBus;
        RecordParser parser = RecordParser.newFixed(4);
        parser.setOutput(this::decodeMessage);
        this.socket = socket;
        this.parser = parser;
    }

    @Override
    public void handle(Buffer data2) {
        this.parser.handle(data2);
    }

    InboundConnection handler(Handler<ClusteredMessage<?, ?>> messageHandler) {
        this.handler = messageHandler;
        return this;
    }

    private void decodeMessage(Buffer buff) {
        if (this.size == -1) {
            this.size = buff.getInt(0);
            this.parser.fixedSizeMode(this.size);
        } else {
            ClusteredMessage received = new ClusteredMessage(this.clusteredEventBus);
            received.readFromWire(buff, this.clusteredEventBus.codecManager());
            this.parser.fixedSizeMode(4);
            this.size = -1;
            if (received.hasFailure()) {
                received.internalError();
            } else if (received.codec() == CodecManager.PING_MESSAGE_CODEC) {
                this.socket.write(PONG);
            } else {
                EventBusMetrics<?> metrics2 = this.clusteredEventBus.metrics();
                if (metrics2 != null) {
                    metrics2.messageRead(received.address(), buff.length());
                }
                this.handler.handle(received);
            }
        }
    }
}

