/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered.selector;

import io.vertx.core.eventbus.impl.clustered.selector.Index;
import io.vertx.core.eventbus.impl.clustered.selector.RoundRobinSelector;
import io.vertx.core.eventbus.impl.clustered.selector.Weight;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WeightedRoundRobinSelector
implements RoundRobinSelector {
    private final List<String> uniqueIds;
    private final TreeMap<Integer, Integer> offsets = new TreeMap();
    private final Index index;

    public WeightedRoundRobinSelector(Map<String, Weight> weights) {
        ArrayList<String> uniqueIds = new ArrayList<String>(weights.size());
        ArrayList<Map.Entry<String, Weight>> sorted2 = new ArrayList<Map.Entry<String, Weight>>(weights.entrySet());
        sorted2.sort(Map.Entry.comparingByValue());
        int totalWeight = 0;
        for (int i = 0; i < sorted2.size(); ++i) {
            Map.Entry current = (Map.Entry)sorted2.get(i);
            uniqueIds.add((String)current.getKey());
            int weight = ((Weight)current.getValue()).value();
            totalWeight += weight;
            if (i >= sorted2.size() - 1) continue;
            int increment = weight - (i == 0 ? 0 : ((Weight)((Map.Entry)sorted2.get(i - 1)).getValue()).value());
            int limit = (i == 0 ? 0 : this.offsets.lastKey()) + (weights.size() - i) * increment;
            this.offsets.put(limit, i + 1);
        }
        this.uniqueIds = Collections.unmodifiableList(uniqueIds);
        this.index = new Index(totalWeight);
    }

    @Override
    public String selectForSend() {
        int idx = this.index.nextVal();
        Map.Entry<Integer, Integer> entry = this.offsets.floorEntry(idx);
        if (entry == null) {
            return this.uniqueIds.get(idx % this.uniqueIds.size());
        }
        int offset2 = entry.getValue();
        if (offset2 == this.uniqueIds.size() - 1) {
            return this.uniqueIds.get(offset2);
        }
        return this.uniqueIds.get(offset2 + idx % (this.uniqueIds.size() - offset2));
    }

    @Override
    public Iterable<String> selectForPublish() {
        return this.uniqueIds;
    }
}

