/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.file.FileSystemProps;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.file.impl.AsyncFileImpl;
import io.vertx.core.file.impl.FilePropsImpl;
import io.vertx.core.file.impl.FileSystemPropsImpl;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class FileSystemImpl
implements FileSystem {
    private static final CopyOptions DEFAULT_OPTIONS = new CopyOptions();
    protected final VertxInternal vertx;

    public FileSystemImpl(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public Future<Void> copy(String from, String to) {
        return this.copy(from, to, DEFAULT_OPTIONS);
    }

    @Override
    public Future<Void> copy(String from, String to, CopyOptions options2) {
        return this.copyInternal(from, to, options2).run();
    }

    @Override
    public FileSystem copyBlocking(String from, String to) {
        this.copyInternal(from, to, DEFAULT_OPTIONS).perform();
        return this;
    }

    @Override
    public Future<Void> copyRecursive(String from, String to, boolean recursive) {
        return this.copyRecursiveInternal(from, to, recursive).run();
    }

    @Override
    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.copyRecursiveInternal(from, to, recursive).perform();
        return this;
    }

    @Override
    public Future<Void> move(String from, String to) {
        return this.move(from, to, DEFAULT_OPTIONS);
    }

    @Override
    public Future<Void> move(String from, String to, CopyOptions options2) {
        return this.moveInternal(from, to, options2).run();
    }

    @Override
    public FileSystem moveBlocking(String from, String to) {
        this.moveInternal(from, to, DEFAULT_OPTIONS).perform();
        return this;
    }

    @Override
    public Future<Void> truncate(String path, long len) {
        return this.truncateInternal(path, len).run();
    }

    @Override
    public FileSystem truncateBlocking(String path, long len) {
        this.truncateInternal(path, len).perform();
        return this;
    }

    @Override
    public Future<Void> chmod(String path, String perms) {
        return this.chmodInternal(path, perms).run();
    }

    @Override
    public FileSystem chmodBlocking(String path, String perms) {
        this.chmodInternal(path, perms).perform();
        return this;
    }

    @Override
    public Future<Void> chmodRecursive(String path, String perms, String dirPerms) {
        return this.chmodInternal(path, perms, dirPerms).run();
    }

    @Override
    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.chmodInternal(path, perms, dirPerms).perform();
        return this;
    }

    @Override
    public Future<Void> chown(String path, @Nullable String user, @Nullable String group) {
        return this.chownInternal(path, user, group).run();
    }

    @Override
    public FileSystem chownBlocking(String path, String user, String group) {
        this.chownInternal(path, user, group).perform();
        return this;
    }

    @Override
    public Future<FileProps> props(String path) {
        return this.propsInternal(path).run();
    }

    @Override
    public FileProps propsBlocking(String path) {
        return this.propsInternal(path).perform();
    }

    @Override
    public Future<FileProps> lprops(String path) {
        return this.lpropsInternal(path).run();
    }

    @Override
    public FileProps lpropsBlocking(String path) {
        return this.lpropsInternal(path).perform();
    }

    @Override
    public Future<Void> link(String link, String existing) {
        return this.linkInternal(link, existing).run();
    }

    @Override
    public FileSystem linkBlocking(String link, String existing) {
        this.linkInternal(link, existing).perform();
        return this;
    }

    @Override
    public Future<Void> symlink(String link, String existing) {
        return this.symlinkInternal(link, existing).run();
    }

    @Override
    public FileSystem symlinkBlocking(String link, String existing) {
        this.symlinkInternal(link, existing).perform();
        return this;
    }

    @Override
    public Future<Void> unlink(String link) {
        return this.unlinkInternal(link).run();
    }

    @Override
    public FileSystem unlinkBlocking(String link) {
        this.unlinkInternal(link).perform();
        return this;
    }

    @Override
    public Future<String> readSymlink(String link) {
        return this.readSymlinkInternal(link).run();
    }

    @Override
    public String readSymlinkBlocking(String link) {
        return this.readSymlinkInternal(link).perform();
    }

    @Override
    public Future<Void> delete(String path) {
        return this.deleteInternal(path).run();
    }

    @Override
    public FileSystem deleteBlocking(String path) {
        this.deleteInternal(path).perform();
        return this;
    }

    @Override
    public Future<Void> deleteRecursive(String path) {
        return this.deleteInternal(path, true).run();
    }

    @Override
    public FileSystem deleteRecursiveBlocking(String path) {
        this.deleteInternal(path, true).perform();
        return this;
    }

    @Override
    public Future<Void> mkdir(String path) {
        return this.mkdirInternal(path).run();
    }

    @Override
    public FileSystem mkdirBlocking(String path) {
        this.mkdirInternal(path).perform();
        return this;
    }

    @Override
    public Future<Void> mkdirs(String path) {
        return this.mkdirInternal(path, true).run();
    }

    @Override
    public FileSystem mkdirsBlocking(String path) {
        this.mkdirInternal(path, true).perform();
        return this;
    }

    @Override
    public Future<Void> mkdir(String path, String perms) {
        return this.mkdirInternal(path, perms).run();
    }

    @Override
    public FileSystem mkdirBlocking(String path, String perms) {
        this.mkdirInternal(path, perms).perform();
        return this;
    }

    @Override
    public Future<Void> mkdirs(String path, String perms) {
        return this.mkdirInternal(path, perms, true).run();
    }

    @Override
    public FileSystem mkdirsBlocking(String path, String perms) {
        this.mkdirInternal(path, perms, true).perform();
        return this;
    }

    @Override
    public Future<List<String>> readDir(String path) {
        return this.readDirInternal(path).run();
    }

    @Override
    public List<String> readDirBlocking(String path) {
        return this.readDirInternal(path).perform();
    }

    @Override
    public Future<List<String>> readDir(String path, String filter2) {
        return this.readDirInternal(path, filter2).run();
    }

    @Override
    public List<String> readDirBlocking(String path, String filter2) {
        return this.readDirInternal(path, filter2).perform();
    }

    @Override
    public Future<Buffer> readFile(String path) {
        return this.readFileInternal(path).run();
    }

    @Override
    public Buffer readFileBlocking(String path) {
        return this.readFileInternal(path).perform();
    }

    @Override
    public Future<Void> writeFile(String path, Buffer data2) {
        return this.writeFileInternal(path, data2).run();
    }

    @Override
    public FileSystem writeFileBlocking(String path, Buffer data2) {
        this.writeFileInternal(path, data2).perform();
        return this;
    }

    @Override
    public Future<AsyncFile> open(String path, OpenOptions options2) {
        return this.openInternal(path, options2).run();
    }

    @Override
    public AsyncFile openBlocking(String path, OpenOptions options2) {
        return this.openInternal(path, options2).perform();
    }

    @Override
    public Future<Void> createFile(String path) {
        return this.createFileInternal(path).run();
    }

    @Override
    public FileSystem createFileBlocking(String path) {
        this.createFileInternal(path).perform();
        return this;
    }

    @Override
    public Future<Void> createFile(String path, String perms) {
        return this.createFileInternal(path, perms).run();
    }

    @Override
    public FileSystem createFileBlocking(String path, String perms) {
        this.createFileInternal(path, perms).perform();
        return this;
    }

    @Override
    public Future<Boolean> exists(String path) {
        return this.existsInternal(path).run();
    }

    @Override
    public boolean existsBlocking(String path) {
        return this.existsInternal(path).perform();
    }

    @Override
    public Future<FileSystemProps> fsProps(String path) {
        return this.fsPropsInternal(path).run();
    }

    @Override
    public FileSystemProps fsPropsBlocking(String path) {
        return this.fsPropsInternal(path).perform();
    }

    @Override
    public Future<String> createTempDirectory(String prefix) {
        return this.createTempDirectoryInternal(null, prefix, null).run();
    }

    @Override
    public String createTempDirectoryBlocking(String prefix) {
        return this.createTempDirectoryInternal(null, prefix, null).perform();
    }

    @Override
    public Future<String> createTempDirectory(String prefix, String perms) {
        return this.createTempDirectoryInternal(null, prefix, perms).run();
    }

    @Override
    public String createTempDirectoryBlocking(String prefix, String perms) {
        return this.createTempDirectoryInternal(null, prefix, perms).perform();
    }

    @Override
    public Future<String> createTempDirectory(String dir, String prefix, String perms) {
        return this.createTempDirectoryInternal(dir, prefix, perms).run();
    }

    @Override
    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        return this.createTempDirectoryInternal(dir, prefix, perms).perform();
    }

    @Override
    public Future<String> createTempFile(String prefix, String suffix) {
        return this.createTempFileInternal(null, prefix, suffix, null).run();
    }

    @Override
    public String createTempFileBlocking(String prefix, String suffix) {
        return this.createTempFileInternal(null, prefix, suffix, null).perform();
    }

    @Override
    public Future<String> createTempFile(String prefix, String suffix, String perms) {
        return this.createTempFileInternal(null, prefix, suffix, perms).run();
    }

    @Override
    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        return this.createTempFileInternal(null, prefix, suffix, perms).perform();
    }

    @Override
    public Future<String> createTempFile(String dir, String prefix, String suffix, String perms) {
        return this.createTempFileInternal(dir, prefix, suffix, perms).run();
    }

    @Override
    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        return this.createTempFileInternal(dir, prefix, suffix, perms).perform();
    }

    static String getFileAccessErrorMessage(String action, String path) {
        return "Unable to " + action + " file at path '" + path + "'";
    }

    static String getFolderAccessErrorMessage(String action, String path) {
        return "Unable to " + action + " folder at path '" + path + "'";
    }

    static String getFileCopyErrorMessage(String from, String to) {
        return FileSystemImpl.getFileDualOperationErrorMessage("copy", from, to);
    }

    static String getFileMoveErrorMessage(String from, String to) {
        return FileSystemImpl.getFileDualOperationErrorMessage("move", from, to);
    }

    static String getFileDualOperationErrorMessage(String action, String from, String to) {
        return "Unable to " + action + " file from '" + from + "' to '" + to + "'";
    }

    private BlockingAction<Void> copyInternal(final String from, final String to, CopyOptions options2) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(options2);
        Set<CopyOption> copyOptionSet = FileSystemImpl.toCopyOptionSet(options2);
        final CopyOption[] copyOptions = copyOptionSet.toArray(new CopyOption[0]);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.resolveFile(from).toPath();
                    Path target = FileSystemImpl.this.resolveFile(to).toPath();
                    Files.copy(source2, target, copyOptions);
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileCopyErrorMessage(from, to), e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> copyRecursiveInternal(final String from, final String to, final boolean recursive) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    final Path source2 = FileSystemImpl.this.resolveFile(from).toPath();
                    final Path target = FileSystemImpl.this.resolveFile(to).toPath();
                    if (recursive) {
                        Files.walkFileTree(source2, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                block2: {
                                    Path targetDir = target.resolve(source2.relativize(dir));
                                    try {
                                        Files.copy(dir, targetDir, new CopyOption[0]);
                                    }
                                    catch (FileAlreadyExistsException e) {
                                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                        throw e;
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.copy(file, target.resolve(source2.relativize(file)), new CopyOption[0]);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.copy(source2, target, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileCopyErrorMessage(from, to), e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> moveInternal(final String from, final String to, CopyOptions options2) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(options2);
        Set<CopyOption> copyOptionSet = FileSystemImpl.toCopyOptionSet(options2);
        final CopyOption[] copyOptions = copyOptionSet.toArray(new CopyOption[0]);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.resolveFile(from).toPath();
                    Path target = FileSystemImpl.this.resolveFile(to).toPath();
                    Files.move(source2, target, copyOptions);
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileMoveErrorMessage(from, to), e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> truncateInternal(final String p, final long len) {
        Objects.requireNonNull(p);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    String path = FileSystemImpl.this.resolveFile(p).getAbsolutePath();
                    if (len < 0L) {
                        throw new FileSystemException("Cannot truncate file to size < 0");
                    }
                    if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                        throw new FileSystemException("Cannot truncate file " + path + ". Does not exist");
                    }
                    try (RandomAccessFile raf = new RandomAccessFile(path, "rw");){
                        raf.setLength(len);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("truncate", p), e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> chmodInternal(String path, String perms) {
        return this.chmodInternal(path, perms, null);
    }

    protected BlockingAction<Void> chmodInternal(final String path, String perms, String dirPerms) {
        Objects.requireNonNull(path);
        final Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(perms);
        final Set<PosixFilePermission> dirPermissions = dirPerms == null ? null : PosixFilePermissions.fromString(dirPerms);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.resolveFile(path).toPath();
                    if (dirPermissions != null) {
                        Files.walkFileTree(target, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(dir, dirPermissions);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(file, permissions);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.setPosixFilePermissions(target, permissions);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chmod on " + path);
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("chmod", path), e);
                }
                return null;
            }
        };
    }

    protected BlockingAction<Void> chownInternal(final String path, final String user, final String group) {
        Objects.requireNonNull(path);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    GroupPrincipal groupPrincipal;
                    Path target = FileSystemImpl.this.resolveFile(path).toPath();
                    UserPrincipalLookupService service = target.getFileSystem().getUserPrincipalLookupService();
                    UserPrincipal userPrincipal = user == null ? null : service.lookupPrincipalByName(user);
                    GroupPrincipal groupPrincipal2 = groupPrincipal = group == null ? null : service.lookupPrincipalByGroupName(group);
                    if (groupPrincipal != null) {
                        PosixFileAttributeView view = Files.getFileAttributeView(target, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                        if (view == null) {
                            throw new FileSystemException("Change group of file not supported");
                        }
                        view.setGroup(groupPrincipal);
                    }
                    if (userPrincipal != null) {
                        Files.setOwner(target, userPrincipal);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chown on " + path);
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("crown", path), e);
                }
                return null;
            }
        };
    }

    private BlockingAction<FileProps> propsInternal(String path) {
        return this.props(path, true);
    }

    private BlockingAction<FileProps> lpropsInternal(String path) {
        return this.props(path, false);
    }

    private BlockingAction<FileProps> props(final String path, final boolean followLinks) {
        Objects.requireNonNull(path);
        return new BlockingAction<FileProps>(){

            @Override
            public FileProps perform() {
                try {
                    Path target = FileSystemImpl.this.resolveFile(path).toPath();
                    BasicFileAttributes attrs = followLinks ? Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]) : Files.readAttributes(target, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    return new FilePropsImpl(attrs);
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("analyse", path), e);
                }
            }
        };
    }

    private BlockingAction<Void> linkInternal(String link, String existing) {
        return this.link(link, existing, false);
    }

    private BlockingAction<Void> symlinkInternal(String link, String existing) {
        return this.link(link, existing, true);
    }

    private BlockingAction<Void> link(final String link, final String existing, final boolean symbolic) {
        Objects.requireNonNull(link);
        Objects.requireNonNull(existing);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.resolveFile(link).toPath();
                    Path target = FileSystemImpl.this.resolveFile(existing).toPath();
                    if (symbolic) {
                        Files.createSymbolicLink(source2, target, new FileAttribute[0]);
                    } else {
                        Files.createLink(source2, target);
                    }
                }
                catch (IOException e) {
                    String message = "Unable to link existing file '" + existing + "' to '" + link + "'";
                    throw new FileSystemException(message, e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> unlinkInternal(String link) {
        return this.deleteInternal(link);
    }

    private BlockingAction<String> readSymlinkInternal(final String link) {
        Objects.requireNonNull(link);
        return new BlockingAction<String>(){

            @Override
            public String perform() {
                try {
                    Path source2 = FileSystemImpl.this.resolveFile(link).toPath();
                    return Files.readSymbolicLink(source2).toString();
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("read", link), e);
                }
            }
        };
    }

    private BlockingAction<Void> deleteInternal(String path) {
        return this.deleteInternal(path, false);
    }

    private BlockingAction<Void> deleteInternal(final String path, final boolean recursive) {
        Objects.requireNonNull(path);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.resolveFile(path).toPath();
                    FileSystemImpl.delete(source2, recursive);
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("delete", path), e);
                }
                return null;
            }
        };
    }

    public static void delete(Path path, boolean recursive) throws IOException {
        if (recursive) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        } else {
            Files.delete(path);
        }
    }

    private BlockingAction<Void> mkdirInternal(String path) {
        return this.mkdirInternal(path, null, false);
    }

    private BlockingAction<Void> mkdirInternal(String path, boolean createParents) {
        return this.mkdirInternal(path, null, createParents);
    }

    private BlockingAction<Void> mkdirInternal(String path, String perms) {
        return this.mkdirInternal(path, perms, false);
    }

    protected BlockingAction<Void> mkdirInternal(final String path, String perms, final boolean createParents) {
        Objects.requireNonNull(path);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.resolveFile(path).toPath();
                    if (createParents) {
                        if (attrs != null) {
                            Files.createDirectories(source2, attrs);
                        } else {
                            Files.createDirectories(source2, new FileAttribute[0]);
                        }
                    } else if (attrs != null) {
                        Files.createDirectory(source2, attrs);
                    } else {
                        Files.createDirectory(source2, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFolderAccessErrorMessage("create", path), e);
                }
                return null;
            }
        };
    }

    protected BlockingAction<String> createTempDirectoryInternal(final String parentDir, final String prefix, String perms) {
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<String>(){

            @Override
            public String perform() {
                try {
                    Path tmpDir;
                    if (parentDir != null) {
                        Path dir = FileSystemImpl.this.resolveFile(parentDir).toPath();
                        tmpDir = attrs != null ? Files.createTempDirectory(dir, prefix, attrs) : Files.createTempDirectory(dir, prefix, new FileAttribute[0]);
                    } else {
                        tmpDir = attrs != null ? Files.createTempDirectory(prefix, attrs) : Files.createTempDirectory(prefix, new FileAttribute[0]);
                    }
                    return tmpDir.toFile().getAbsolutePath();
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFolderAccessErrorMessage("create subfolder of", parentDir), e);
                }
            }
        };
    }

    protected BlockingAction<String> createTempFileInternal(final String parentDir, final String prefix, final String suffix, String perms) {
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<String>(){

            @Override
            public String perform() {
                try {
                    Path tmpFile;
                    if (parentDir != null) {
                        Path dir = FileSystemImpl.this.resolveFile(parentDir).toPath();
                        tmpFile = attrs != null ? Files.createTempFile(dir, prefix, suffix, attrs) : Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]);
                    } else {
                        tmpFile = attrs != null ? Files.createTempFile(prefix, suffix, attrs) : Files.createTempFile(prefix, suffix, new FileAttribute[0]);
                    }
                    return tmpFile.toFile().getAbsolutePath();
                }
                catch (IOException e) {
                    String message = "Unable to create temporary file with prefix '" + prefix + "' and suffix '" + suffix + "' at " + parentDir;
                    throw new FileSystemException(message, e);
                }
            }
        };
    }

    private BlockingAction<List<String>> readDirInternal(String path) {
        return this.readDirInternal(path, null);
    }

    private BlockingAction<List<String>> readDirInternal(final String p, final String filter2) {
        Objects.requireNonNull(p);
        return new BlockingAction<List<String>>(){

            @Override
            public List<String> perform() {
                try {
                    File file = FileSystemImpl.this.resolveFile(p);
                    if (!file.exists()) {
                        throw new FileSystemException("Cannot read directory " + String.valueOf(file) + ". Does not exist");
                    }
                    if (!file.isDirectory()) {
                        throw new FileSystemException("Cannot read directory " + String.valueOf(file) + ". It's not a directory");
                    }
                    FilenameFilter fnFilter = filter2 != null ? new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return Pattern.matches(filter2, name);
                        }
                    } : null;
                    File[] files = fnFilter == null ? file.listFiles() : file.listFiles(fnFilter);
                    ArrayList<String> ret = new ArrayList<String>(files.length);
                    for (File f : files) {
                        ret.add(f.getCanonicalPath());
                    }
                    return ret;
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFolderAccessErrorMessage("read", p), e);
                }
            }
        };
    }

    private BlockingAction<Buffer> readFileInternal(final String path) {
        Objects.requireNonNull(path);
        return new BlockingAction<Buffer>(){

            @Override
            public Buffer perform() {
                try {
                    Path target = FileSystemImpl.this.resolveFile(path).toPath();
                    byte[] bytes = Files.readAllBytes(target);
                    return Buffer.buffer(bytes);
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("read", path), e);
                }
            }
        };
    }

    private BlockingAction<Void> writeFileInternal(final String path, final Buffer data2) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(data2);
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.resolveFile(path).toPath();
                    Files.write(target, data2.getBytes(), new OpenOption[0]);
                    return null;
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("write", path), e);
                }
            }
        };
    }

    private BlockingAction<AsyncFile> openInternal(final String p, final OpenOptions options2) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(options2);
        return new BlockingAction<AsyncFile>(){

            @Override
            public AsyncFile perform() {
                String path = FileSystemImpl.this.resolveFile(p).getAbsolutePath();
                return FileSystemImpl.this.doOpen(path, options2, this.context);
            }
        };
    }

    protected AsyncFile doOpen(String path, OpenOptions options2, ContextInternal context2) {
        return new AsyncFileImpl(this.vertx, path, options2, context2);
    }

    private BlockingAction<Void> createFileInternal(String path) {
        return this.createFileInternal(path, null);
    }

    protected BlockingAction<Void> createFileInternal(final String p, String perms) {
        Objects.requireNonNull(p);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.resolveFile(p).toPath();
                    if (attrs != null) {
                        Files.createFile(target, attrs);
                    } else {
                        Files.createFile(target, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("create", p), e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Boolean> existsInternal(final String path) {
        Objects.requireNonNull(path);
        return new BlockingAction<Boolean>(){

            @Override
            public Boolean perform() {
                File file = FileSystemImpl.this.resolveFile(path);
                return file.exists();
            }
        };
    }

    private BlockingAction<FileSystemProps> fsPropsInternal(final String path) {
        Objects.requireNonNull(path);
        return new BlockingAction<FileSystemProps>(){

            @Override
            public FileSystemProps perform() {
                try {
                    Path target = FileSystemImpl.this.resolveFile(path).toPath();
                    FileStore fs = Files.getFileStore(target);
                    return new FileSystemPropsImpl(fs.name(), fs.getTotalSpace(), fs.getUnallocatedSpace(), fs.getUsableSpace());
                }
                catch (IOException e) {
                    throw new FileSystemException(FileSystemImpl.getFileAccessErrorMessage("analyse", path), e);
                }
            }
        };
    }

    private File resolveFile(String from) {
        return this.vertx.fileResolver().resolve(from);
    }

    public static Set<CopyOption> toCopyOptionSet(CopyOptions copyOptions) {
        HashSet<CopyOption> copyOptionSet = new HashSet<CopyOption>();
        if (copyOptions.isReplaceExisting()) {
            copyOptionSet.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (copyOptions.isCopyAttributes()) {
            copyOptionSet.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        if (copyOptions.isAtomicMove()) {
            copyOptionSet.add(StandardCopyOption.ATOMIC_MOVE);
        }
        if (copyOptions.isNofollowLinks()) {
            copyOptionSet.add(LinkOption.NOFOLLOW_LINKS);
        }
        return copyOptionSet;
    }

    protected abstract class BlockingAction<T>
    implements Callable<T> {
        protected final ContextInternal context;

        protected BlockingAction() {
            this.context = FileSystemImpl.this.vertx.getOrCreateContext();
        }

        public Future<T> run() {
            return this.context.executeBlockingInternal(this);
        }

        @Override
        public T call() throws Exception {
            return this.perform();
        }

        public abstract T perform();
    }
}

