/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.ServerWebSocketHandshake;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.util.concurrent.TimeUnit;

@VertxGen
public interface HttpServer
extends Measured {
    @Fluent
    public HttpServer requestHandler(Handler<HttpServerRequest> var1);

    @GenIgnore
    public Handler<HttpServerRequest> requestHandler();

    public HttpServer invalidRequestHandler(Handler<HttpServerRequest> var1);

    @Fluent
    public HttpServer connectionHandler(Handler<HttpConnection> var1);

    @Fluent
    public HttpServer webSocketHandshakeHandler(Handler<ServerWebSocketHandshake> var1);

    @Fluent
    public HttpServer exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public HttpServer webSocketHandler(Handler<ServerWebSocket> var1);

    @GenIgnore
    public Handler<ServerWebSocket> webSocketHandler();

    default public Future<Boolean> updateSSLOptions(ServerSSLOptions options2) {
        return this.updateSSLOptions(options2, false);
    }

    public Future<Boolean> updateSSLOptions(ServerSSLOptions var1, boolean var2);

    public Future<Boolean> updateTrafficShapingOptions(TrafficShapingOptions var1);

    public Future<HttpServer> listen();

    default public Future<HttpServer> listen(int port, String host) {
        return this.listen(new SocketAddressImpl(port, host));
    }

    public Future<HttpServer> listen(SocketAddress var1);

    default public Future<HttpServer> listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    default public Future<Void> close() {
        return this.shutdown(0L, TimeUnit.SECONDS);
    }

    default public Future<Void> shutdown() {
        return this.shutdown(30L, TimeUnit.SECONDS);
    }

    public Future<Void> shutdown(long var1, TimeUnit var3);

    public int actualPort();
}

