/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpConnectOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptionsConverter;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.Address;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class RequestOptions
extends HttpConnectOptions {
    public static final SocketAddress DEFAULT_SERVER = null;
    public static final HttpMethod DEFAULT_HTTP_METHOD = HttpMethod.GET;
    public static final String DEFAULT_HOST = null;
    public static final Integer DEFAULT_PORT = null;
    public static final Boolean DEFAULT_SSL = null;
    public static final String DEFAULT_URI = "/";
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = false;
    public static final long DEFAULT_TIMEOUT = -1L;
    public static final long DEFAULT_CONNECT_TIMEOUT = -1L;
    public static final long DEFAULT_IDLE_TIMEOUT = -1L;
    private HttpMethod method;
    private String uri;
    private MultiMap headers;
    private boolean followRedirects;
    private long timeout;
    private long idleTimeout;
    private String traceOperation;
    private String routingKey;

    public RequestOptions() {
    }

    public RequestOptions(RequestOptions other) {
        super(other);
        this.setMethod(other.method);
        this.setURI(other.uri);
        this.setFollowRedirects(other.followRedirects);
        this.setIdleTimeout(other.idleTimeout);
        this.setTimeout(other.timeout);
        if (other.headers != null) {
            this.setHeaders(MultiMap.caseInsensitiveMultiMap().setAll(other.headers));
        }
        this.setTraceOperation(other.traceOperation);
    }

    public RequestOptions(JsonObject json2) {
        super(json2);
        JsonObject headers;
        RequestOptionsConverter.fromJson(json2, this);
        String method = json2.getString("method");
        if (method != null) {
            this.setMethod(HttpMethod.valueOf(method));
        }
        if ((headers = json2.getJsonObject("headers")) != null) {
            for (Map.Entry<String, Object> entry : headers) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    this.addHeader(entry.getKey(), (String)value);
                    continue;
                }
                if (!(value instanceof Iterable)) continue;
                for (Object subValue : (Iterable)value) {
                    if (!(subValue instanceof String)) continue;
                    this.addHeader(entry.getKey(), (String)subValue);
                }
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.method = DEFAULT_HTTP_METHOD;
        this.uri = DEFAULT_URI;
        this.followRedirects = false;
        this.timeout = -1L;
        this.idleTimeout = -1L;
        this.traceOperation = null;
    }

    @Override
    public RequestOptions setProxyOptions(ProxyOptions proxyOptions) {
        super.setProxyOptions(proxyOptions);
        return this;
    }

    @Override
    public RequestOptions setServer(Address server) {
        super.setServer(server);
        return this;
    }

    @GenIgnore
    public HttpMethod getMethod() {
        return this.method;
    }

    @GenIgnore
    public RequestOptions setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public RequestOptions setHost(String host) {
        super.setHost(host);
        return this;
    }

    @Override
    public RequestOptions setPort(Integer port) {
        super.setPort(port);
        return this;
    }

    @Override
    public RequestOptions setSsl(Boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public RequestOptions setSslOptions(ClientSSLOptions sslOptions) {
        super.setSslOptions(sslOptions);
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public RequestOptions setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public RequestOptions setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestOptions setTimeout(long timeout2) {
        this.timeout = timeout2;
        return this;
    }

    @Override
    public RequestOptions setConnectTimeout(long timeout2) {
        super.setConnectTimeout(timeout2);
        return this;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public RequestOptions setIdleTimeout(long timeout2) {
        this.idleTimeout = timeout2;
        return this;
    }

    private URL parseUrl(String surl) {
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new VertxException("Invalid url: " + surl, e);
        }
    }

    public RequestOptions setAbsoluteURI(String absoluteURI) {
        Objects.requireNonNull(absoluteURI, "Cannot set a null absolute URI");
        URL url = this.parseUrl(absoluteURI);
        return this.setAbsoluteURI(url);
    }

    @GenIgnore(value={"permitted-type"})
    public RequestOptions setAbsoluteURI(URL url) {
        String protocol;
        Objects.requireNonNull(url, "Cannot set a null absolute URI");
        Boolean ssl = Boolean.FALSE;
        int port = url.getPort();
        Object relativeUri = url.getPath().isEmpty() ? DEFAULT_URI + url.getFile() : url.getFile();
        switch (protocol = url.getProtocol()) {
            case "http": {
                if (port != -1) break;
                port = 80;
                break;
            }
            case "https": {
                ssl = Boolean.TRUE;
                if (port != -1) break;
                port = 443;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setURI((String)relativeUri);
        this.setPort(port);
        this.setSsl(ssl);
        this.setHost(url.getHost());
        return this;
    }

    @GenIgnore
    public RequestOptions addHeader(String key, String value) {
        return this.addHeader((CharSequence)key, (CharSequence)value);
    }

    @GenIgnore
    public RequestOptions addHeader(CharSequence key, CharSequence value) {
        this.checkHeaders();
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    @GenIgnore
    public RequestOptions addHeader(CharSequence key, Iterable<CharSequence> values2) {
        this.checkHeaders();
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(values2, "no null values accepted");
        this.headers.add(key, values2);
        return this;
    }

    @GenIgnore
    public RequestOptions putHeader(String key, String value) {
        return this.putHeader((CharSequence)key, (CharSequence)value);
    }

    @GenIgnore
    public RequestOptions putHeader(CharSequence key, CharSequence value) {
        this.checkHeaders();
        this.headers.set(key, value);
        return this;
    }

    @GenIgnore
    public RequestOptions putHeader(CharSequence key, Iterable<CharSequence> values2) {
        this.checkHeaders();
        this.headers.set(key, values2);
        return this;
    }

    @GenIgnore
    public RequestOptions removeHeader(String key) {
        return this.removeHeader((CharSequence)key);
    }

    @GenIgnore
    public RequestOptions removeHeader(CharSequence key) {
        if (this.headers != null) {
            this.headers.remove(key);
        }
        return this;
    }

    @GenIgnore
    public RequestOptions setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    private void checkHeaders() {
        if (this.headers == null) {
            this.headers = HttpHeaders.headers();
        }
    }

    public String getTraceOperation() {
        return this.traceOperation;
    }

    public RequestOptions setTraceOperation(String op) {
        this.traceOperation = op;
        return this;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public RequestOptions setRoutingKey(String key) {
        this.routingKey = key;
        return this;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json2 = super.toJson();
        RequestOptionsConverter.toJson(this, json2);
        if (this.method != null) {
            json2.put("method", this.method.name());
        }
        if (this.headers != null) {
            JsonObject headers = new JsonObject();
            for (String name : this.headers.names()) {
                List<String> values2 = this.headers.getAll(name);
                if (values2.size() == 1) {
                    headers.put(name, values2.iterator().next());
                    continue;
                }
                headers.put(name, values2);
            }
            json2.put("headers", headers);
        }
        return json2;
    }
}

