/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class StreamPriority {
    public static final int DEFAULT_DEPENDENCY = 0;
    public static final short DEFAULT_WEIGHT = 16;
    public static final boolean DEFAULT_EXCLUSIVE = false;
    private short weight;
    private int dependency;
    private boolean exclusive;

    public StreamPriority() {
        this.weight = (short)16;
        this.dependency = 0;
        this.exclusive = false;
    }

    public StreamPriority(JsonObject json2) {
        this.weight = json2.getInteger("weight", 16).shortValue();
        this.dependency = json2.getInteger("dependency", 0);
        this.exclusive = json2.getBoolean("exclusive", false);
    }

    public StreamPriority(StreamPriority other) {
        this.weight = other.weight;
        this.dependency = other.dependency;
        this.exclusive = other.exclusive;
    }

    public short getWeight() {
        return this.weight;
    }

    public StreamPriority setWeight(short weight) {
        this.weight = weight;
        return this;
    }

    public int getDependency() {
        return this.dependency;
    }

    public StreamPriority setDependency(int dependency) {
        this.dependency = dependency;
        return this;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public StreamPriority setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.exclusive ? 1231 : 1237);
        result2 = 31 * result2 + this.dependency;
        result2 = 31 * result2 + this.weight;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamPriority other = (StreamPriority)obj;
        if (this.exclusive != other.exclusive) {
            return false;
        }
        if (this.dependency != other.dependency) {
            return false;
        }
        return this.weight == other.weight;
    }

    public JsonObject toJson() {
        JsonObject json2 = new JsonObject();
        json2.put("weight", this.weight);
        json2.put("dependency", this.dependency);
        json2.put("exclusive", this.exclusive);
        return json2;
    }

    public String toString() {
        return "StreamPriority [weight=" + this.weight + ", dependency=" + this.dependency + ", exclusive=" + this.exclusive + "]";
    }
}

