/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

@VertxGen(concrete=false)
public interface WebSocketBase
extends ReadStream<Buffer>,
WriteStream<Buffer> {
    @Override
    public WebSocketBase exceptionHandler(Handler<Throwable> var1);

    public WebSocketBase handler(Handler<Buffer> var1);

    public WebSocketBase pause();

    public WebSocketBase resume();

    public WebSocketBase fetch(long var1);

    public WebSocketBase endHandler(Handler<Void> var1);

    public WebSocketBase setWriteQueueMaxSize(int var1);

    public WebSocketBase drainHandler(Handler<Void> var1);

    public String binaryHandlerID();

    public String textHandlerID();

    public String subProtocol();

    public Short closeStatusCode();

    public String closeReason();

    public MultiMap headers();

    public Future<Void> writeFrame(WebSocketFrame var1);

    public Future<Void> writeFinalTextFrame(String var1);

    public Future<Void> writeFinalBinaryFrame(Buffer var1);

    public Future<Void> writeBinaryMessage(Buffer var1);

    public Future<Void> writeTextMessage(String var1);

    public Future<Void> writePing(Buffer var1);

    public Future<Void> writePong(Buffer var1);

    @Fluent
    public WebSocketBase closeHandler(@Nullable Handler<Void> var1);

    @Fluent
    public WebSocketBase shutdownHandler(@Nullable Handler<Void> var1);

    @Fluent
    public WebSocketBase frameHandler(@Nullable Handler<WebSocketFrame> var1);

    @Fluent
    public WebSocketBase textMessageHandler(@Nullable Handler<String> var1);

    @Fluent
    public WebSocketBase binaryMessageHandler(@Nullable Handler<Buffer> var1);

    @Fluent
    public WebSocketBase pongHandler(@Nullable Handler<Buffer> var1);

    @Override
    public Future<Void> end();

    default public Future<Void> close() {
        return this.close((short)1000, null);
    }

    default public Future<Void> close(short statusCode) {
        return this.close(statusCode, null);
    }

    default public Future<Void> close(short statusCode, @Nullable String reason) {
        return this.shutdown(0L, TimeUnit.SECONDS, statusCode, reason);
    }

    default public Future<Void> shutdown() {
        return this.shutdown(30L, TimeUnit.SECONDS);
    }

    default public Future<Void> shutdown(short statusCode) {
        return this.shutdown(30L, TimeUnit.SECONDS, statusCode);
    }

    default public Future<Void> shutdown(short statusCode, @Nullable String reason) {
        return this.shutdown(30L, TimeUnit.SECONDS, statusCode, reason);
    }

    default public Future<Void> shutdown(long timeout2, TimeUnit unit) {
        return this.shutdown(timeout2, unit, (short)1000);
    }

    default public Future<Void> shutdown(long timeout2, TimeUnit unit, short statusCode) {
        return this.shutdown(timeout2, unit, statusCode, null);
    }

    public Future<Void> shutdown(long var1, TimeUnit var3, short var4, @Nullable String var5);

    @CacheReturn
    public SocketAddress remoteAddress();

    @CacheReturn
    public SocketAddress localAddress();

    public boolean isSsl();

    public boolean isClosed();

    @GenIgnore(value={"permitted-type"})
    public SSLSession sslSession();

    @GenIgnore
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException;
}

