/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.HttpUtils;
import java.net.URI;
import java.util.function.Function;

public class DefaultRedirectHandler
implements Function<HttpClientResponse, Future<RequestOptions>> {
    @Override
    public Future<RequestOptions> apply(HttpClientResponse resp) {
        try {
            int statusCode = resp.statusCode();
            String location = resp.getHeader(HttpHeaders.LOCATION);
            if (location != null && (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308)) {
                String query;
                Object requestURI;
                boolean ssl;
                HttpMethod m = resp.request().getMethod();
                if (statusCode == 303) {
                    m = HttpMethod.GET;
                } else if (m != HttpMethod.GET && m != HttpMethod.HEAD) {
                    return null;
                }
                URI uri = HttpUtils.resolveURIReference(resp.request().absoluteURI(), location);
                int port = uri.getPort();
                String protocol = uri.getScheme();
                char chend = protocol.charAt(protocol.length() - 1);
                if (chend == 'p') {
                    ssl = false;
                    if (port == -1) {
                        port = 80;
                    }
                } else if (chend == 's') {
                    ssl = true;
                    if (port == -1) {
                        port = 443;
                    }
                } else {
                    return null;
                }
                if ((requestURI = uri.getPath()) == null || ((String)requestURI).isEmpty()) {
                    requestURI = "/";
                }
                if ((query = uri.getQuery()) != null) {
                    requestURI = (String)requestURI + "?" + query;
                }
                RequestOptions options2 = new RequestOptions();
                options2.setMethod(m);
                options2.setHost(uri.getHost());
                options2.setPort(port);
                options2.setSsl(ssl);
                options2.setURI((String)requestURI);
                options2.setHeaders(resp.request().headers());
                options2.removeHeader(HttpHeaders.CONTENT_LENGTH);
                return Future.succeededFuture(options2);
            }
            return null;
        }
        catch (Exception e) {
            return Future.failedFuture(e);
        }
    }
}

