/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.ServerWebSocketHandshake;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.HttpServerConnectionHandler;
import io.vertx.core.http.impl.ServerWebSocketHandshaker;

public class Http1xServerRequestHandler
implements Handler<HttpServerRequest> {
    private final HttpServerConnectionHandler handlers;

    public Http1xServerRequestHandler(HttpServerConnectionHandler handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(HttpServerRequest req) {
        Handler<ServerWebSocket> wsHandler = this.handlers.webSocketHandler;
        Handler<ServerWebSocketHandshake> wsHandshakeHandler = this.handlers.webSocketHandshakeHandler;
        Handler<HttpServerRequest> reqHandler = this.handlers.requestHandler;
        if (wsHandler != null || wsHandshakeHandler != null) {
            if (req.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) && this.handlers.server.wsAccept()) {
                ((Http1xServerRequest)req).webSocketHandshake().onComplete(ar -> {
                    if (ar.succeeded()) {
                        ServerWebSocketHandshaker handshake2 = (ServerWebSocketHandshaker)ar.result();
                        if (wsHandshakeHandler == null) {
                            handshake2.accept();
                        } else {
                            wsHandshakeHandler.handle(handshake2);
                        }
                        if (wsHandler != null) {
                            handshake2.onSuccess(wsHandler);
                        }
                    }
                });
            } else if (reqHandler != null) {
                reqHandler.handle(req);
            } else {
                req.response().setStatusCode(400).end();
            }
        } else if (req.version() == null) {
            req.response().setStatusCode(501).end();
            req.connection().close();
        } else {
            reqHandler.handle(req);
        }
    }
}

