/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClientConnection;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class UnpooledHttpClientConnection
implements HttpClientConnection {
    private final HttpClientConnectionInternal actual;
    private final Deque<PromiseInternal<HttpClientStream>> pending;
    private long concurrency;
    private long inflight;

    public UnpooledHttpClientConnection(HttpClientConnectionInternal actual) {
        this.actual = actual;
        this.concurrency = actual.concurrency();
        this.pending = new ArrayDeque<PromiseInternal<HttpClientStream>>();
    }

    UnpooledHttpClientConnection init() {
        this.actual.evictionHandler(v -> {});
        this.actual.concurrencyChangeHandler(val -> {
            UnpooledHttpClientConnection unpooledHttpClientConnection = this;
            synchronized (unpooledHttpClientConnection) {
                this.concurrency = val;
            }
            this.checkPending(null);
        });
        return this;
    }

    @Override
    public long activeStreams() {
        return this.actual.activeStreams();
    }

    @Override
    public synchronized long maxActiveStreams() {
        return this.concurrency;
    }

    @Override
    public Future<Void> shutdown(long timeout2, TimeUnit unit) {
        return this.actual.shutdown(timeout2, unit);
    }

    @Override
    public int getWindowSize() {
        return this.actual.getWindowSize();
    }

    @Override
    @Fluent
    public HttpConnection setWindowSize(int windowSize) {
        return this.actual.setWindowSize(windowSize);
    }

    @Override
    @Fluent
    public HttpConnection goAway(long errorCode) {
        return this.actual.goAway(errorCode);
    }

    @Override
    @Fluent
    public HttpConnection goAway(long errorCode, int lastStreamId) {
        return this.actual.goAway(errorCode, lastStreamId);
    }

    @Override
    @Fluent
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        return this.actual.goAway(errorCode, lastStreamId, debugData);
    }

    @Override
    @Fluent
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        return this.actual.goAwayHandler(handler);
    }

    @Override
    @Fluent
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        return this.actual.shutdownHandler(handler);
    }

    @Override
    @Fluent
    public HttpConnection closeHandler(Handler<Void> handler) {
        return this.actual.closeHandler(handler);
    }

    @Override
    public Http2Settings settings() {
        return this.actual.settings();
    }

    @Override
    public Future<Void> updateSettings(Http2Settings settings) {
        return this.actual.updateSettings(settings);
    }

    @Override
    public Http2Settings remoteSettings() {
        return this.actual.remoteSettings();
    }

    @Override
    @Fluent
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        return this.actual.remoteSettingsHandler(handler);
    }

    @Override
    public Future<Buffer> ping(Buffer data2) {
        return this.actual.ping(data2);
    }

    @Override
    @Fluent
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        return this.actual.pingHandler(handler);
    }

    @Override
    @Fluent
    public HttpConnection exceptionHandler(Handler<Throwable> handler) {
        return this.actual.exceptionHandler(handler);
    }

    @Override
    @CacheReturn
    public SocketAddress remoteAddress() {
        return this.actual.remoteAddress();
    }

    @Override
    public SocketAddress remoteAddress(boolean real) {
        return this.actual.remoteAddress(real);
    }

    @Override
    @CacheReturn
    public SocketAddress localAddress() {
        return this.actual.localAddress();
    }

    @Override
    public SocketAddress localAddress(boolean real) {
        return this.actual.localAddress(real);
    }

    @Override
    public boolean isSsl() {
        return this.actual.isSsl();
    }

    @Override
    @GenIgnore(value={"permitted-type"})
    public SSLSession sslSession() {
        return this.actual.sslSession();
    }

    @Override
    @GenIgnore
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.actual.peerCertificates();
    }

    @Override
    public String indicatedServerName() {
        return this.actual.indicatedServerName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<HttpClientRequest> request(ContextInternal context2, RequestOptions options2) {
        Future<Object> future;
        UnpooledHttpClientConnection unpooledHttpClientConnection = this;
        synchronized (unpooledHttpClientConnection) {
            if (this.inflight >= this.concurrency) {
                PromiseInternal promise = context2.promise();
                this.pending.add(promise);
                future = promise.future();
            } else {
                ++this.inflight;
                future = this.actual.createStream(context2);
            }
        }
        return future.map(stream -> {
            HttpClientRequestImpl request = new HttpClientRequestImpl(this, (HttpClientStream)stream);
            stream.closeHandler(this::checkPending);
            if (options2 != null) {
                request.init(options2);
            }
            return request;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPending(Void v) {
        PromiseInternal<HttpClientStream> promise;
        UnpooledHttpClientConnection unpooledHttpClientConnection = this;
        synchronized (unpooledHttpClientConnection) {
            if (--this.inflight >= this.concurrency || (promise = this.pending.poll()) == null) {
                return;
            }
            ++this.inflight;
        }
        this.actual.createStream(promise.context()).onComplete(promise);
    }

    @Override
    public Future<HttpClientRequest> request(RequestOptions options2) {
        ContextInternal ctx = this.actual.context().owner().getOrCreateContext();
        return this.request(ctx, options2);
    }
}

