/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import java.util.function.Function;

public class VertxCompressorHttp2ConnectionEncoder
implements Http2FrameWriter,
Http2ConnectionEncoder,
Http2SettingsReceivedConsumer {
    private Http2ConnectionEncoder delegate;
    private final Http2ConnectionEncoder plainEncoder;

    public VertxCompressorHttp2ConnectionEncoder(Http2ConnectionEncoder plainEncoder, CompressionOptions[] compressionOptions) {
        this.delegate = new CompressorHttp2ConnectionEncoder(plainEncoder, compressionOptions);
        this.plainEncoder = plainEncoder;
    }

    private void beforeWritingHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers responseHeaders) {
        String contentEncodingToApply = this.determineContentEncodingToApply(ctx, streamId, responseHeaders);
        if (contentEncodingToApply == null || contentEncodingToApply.equalsIgnoreCase(HttpHeaders.IDENTITY.toString())) {
            if (responseHeaders.contains(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY)) {
                responseHeaders.remove(HttpHeaders.CONTENT_ENCODING);
            }
            this.delegate = this.plainEncoder;
        } else {
            responseHeaders.set(HttpHeaders.CONTENT_ENCODING, contentEncodingToApply);
        }
    }

    private String determineContentEncodingToApply(ChannelHandlerContext ctx, int streamId, Http2Headers responseHeaders) {
        if (responseHeaders.contains(HttpHeaders.CONTENT_ENCODING)) {
            return null;
        }
        return this.ifType(ctx.handler(), VertxHttp2ConnectionHandler.class, connectionHandler -> this.ifType(connectionHandler.connectFuture().getNow(), Http2ServerConnection.class, connection -> this.ifType(connection.stream(streamId), Http2ServerStream.class, stream -> stream.headers == null ? null : connection.determineContentEncoding(stream.headers))));
    }

    private <T, R> R ifType(Object obj, Class<T> type2, Function<T, R> then) {
        return obj != null && type2.isAssignableFrom(obj.getClass()) ? (R)then.apply(type2.cast(obj)) : null;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding2, boolean endStream, ChannelPromise promise) {
        this.beforeWritingHeaders(ctx, streamId, headers);
        return this.delegate.writeHeaders(ctx, streamId, headers, padding2, endStream, promise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding2, boolean endStream, ChannelPromise promise) {
        this.beforeWritingHeaders(ctx, streamId, headers);
        return this.delegate.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding2, endStream, promise);
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.delegate.lifecycleManager(http2LifecycleManager);
    }

    @Override
    public Http2Connection connection() {
        return this.delegate.connection();
    }

    @Override
    public Http2RemoteFlowController flowController() {
        return this.delegate.flowController();
    }

    @Override
    public Http2FrameWriter frameWriter() {
        return this.delegate.frameWriter();
    }

    @Override
    public Http2Settings pollSentSettings() {
        return this.delegate.pollSentSettings();
    }

    @Override
    public void remoteSettings(Http2Settings http2Settings) throws Http2Exception {
        this.delegate.remoteSettings(http2Settings);
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        return this.delegate.writePriority(ctx, streamId, streamDependency, weight, exclusive, promise);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        return this.delegate.writeRstStream(ctx, streamId, errorCode, promise);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext ctx, Http2Settings settings, ChannelPromise promise) {
        return this.delegate.writeSettings(ctx, settings, promise);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        return this.delegate.writeSettingsAck(ctx, promise);
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data2, ChannelPromise promise) {
        return this.delegate.writePing(ctx, ack, data2, promise);
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding2, ChannelPromise promise) {
        return this.delegate.writePushPromise(ctx, streamId, promisedStreamId, headers, padding2, promise);
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        return this.delegate.writeGoAway(ctx, lastStreamId, errorCode, debugData, promise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
        return this.delegate.writeWindowUpdate(ctx, streamId, windowSizeIncrement, promise);
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        return this.delegate.writeFrame(ctx, frameType, streamId, flags, payload, promise);
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this.delegate.configuration();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data2, int padding2, boolean endStream, ChannelPromise promise) {
        return this.delegate.writeData(ctx, streamId, data2, padding2, endStream, promise);
    }

    @Override
    public void consumeReceivedSettings(Http2Settings settings) {
        if (!(this.delegate instanceof Http2SettingsReceivedConsumer)) {
            throw new IllegalStateException("delegate " + String.valueOf(this.delegate) + " is not an instance of " + String.valueOf(Http2SettingsReceivedConsumer.class));
        }
        ((Http2SettingsReceivedConsumer)((Object)this.delegate)).consumeReceivedSettings(settings);
    }
}

