/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.vertx.core.http.WebSocketFrameType;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.net.impl.VertxConnection;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.util.concurrent.TimeUnit;

final class WebSocketConnectionImpl
extends VertxConnection {
    private final long closingTimeoutMS;
    private ScheduledFuture<?> closingTimeout;
    private final boolean server;
    private final TCPMetrics metrics;
    private WebSocketImplBase<?> webSocket;
    private boolean closeSent;
    private ChannelPromise closePromise;
    private Object closeReason;
    private boolean closeReceived;

    WebSocketConnectionImpl(ContextInternal context2, ChannelHandlerContext chctx, boolean server, long closingTimeoutMS, TCPMetrics metrics2) {
        super(context2, chctx);
        this.closingTimeoutMS = closingTimeoutMS;
        this.metrics = metrics2;
        this.server = server;
    }

    WebSocketImplBase<?> webSocket() {
        return this.webSocket;
    }

    WebSocketConnectionImpl webSocket(WebSocketImplBase<?> webSocket) {
        this.webSocket = webSocket;
        return this;
    }

    @Override
    protected long sizeof(Object obj) {
        if (obj instanceof WebSocketFrame) {
            return ((WebSocketFrame)obj).content().readableBytes();
        }
        return super.sizeof(obj);
    }

    @Override
    public NetworkMetrics metrics() {
        return this.metrics;
    }

    @Override
    protected void handleShutdown(Object reason, long timeout2, TimeUnit unit, ChannelPromise promise) {
    }

    @Override
    protected void handleClose(Object reason, ChannelPromise promise) {
        assert (!this.closeSent);
        this.closeSent = true;
        this.closePromise = promise;
        this.closeReason = reason;
        CloseWebSocketFrame closeFrame = reason instanceof CloseWebSocketFrame ? (CloseWebSocketFrame)reason : this.closeFrame((short)1000, null);
        if (this.closeReceived) {
            ChannelPromise channelPromise = this.chctx.newPromise();
            this.writeToChannel((Object)closeFrame, channelPromise);
            if (this.server) {
                channelPromise.addListener(future -> this.finishClose());
            }
        } else {
            ChannelPromise channelPromise = this.chctx.newPromise();
            this.writeToChannel((Object)closeFrame, channelPromise);
            if (this.closingTimeoutMS > 0L) {
                channelPromise.addListener(future -> {
                    EventExecutor exec = this.chctx.executor();
                    this.closingTimeout = exec.schedule(() -> {
                        this.closingTimeout = null;
                        this.finishClose();
                    }, this.closingTimeoutMS, TimeUnit.MILLISECONDS);
                });
            } else if (this.closingTimeoutMS == 0L) {
                channelPromise.addListener(future -> this.finishClose());
            }
        }
    }

    private CloseWebSocketFrame closeFrame(short statusCode, String reason) {
        ByteBuf byteBuf = HttpUtils.generateWSCloseFrameByteBuf(statusCode, reason);
        return new CloseWebSocketFrame(true, 0, byteBuf);
    }

    @Override
    public void handleException(Throwable t) {
        WebSocketImplBase<?> ws = this.webSocket;
        if (ws != null) {
            ws.context().execute(t, ws::handleException);
        }
    }

    @Override
    protected void handleWriteQueueDrained() {
        WebSocketImplBase<?> ws = this.webSocket;
        if (ws != null) {
            ws.context().execute(ws::handleWriteQueueDrained);
        }
    }

    @Override
    protected void handleClosed() {
        ScheduledFuture<?> timeout2 = this.closingTimeout;
        if (timeout2 != null) {
            timeout2.cancel(false);
        }
        if (this.closePromise != null) {
            this.closePromise.setSuccess();
        }
        Object metric = null;
        WebSocketImplBase<?> ws = this.webSocket;
        if (ws != null) {
            ws.context().execute(v -> ws.handleConnectionClosed());
            metric = ws.getMetric();
            ws.setMetric(null);
        }
        if (this.metrics instanceof HttpServerMetrics) {
            HttpServerMetrics metrics2 = (HttpServerMetrics)this.metrics;
            if (Metrics.METRICS_ENABLED && metrics2 != null) {
                metrics2.disconnected(metric);
            }
        } else if (this.metrics instanceof HttpClientMetrics) {
            HttpClientMetrics metrics3 = (HttpClientMetrics)this.metrics;
            if (Metrics.METRICS_ENABLED && metrics3 != null) {
                metrics3.disconnected(metric);
            }
        }
        super.handleClosed();
    }

    @Override
    protected void handleMessage(Object msg) {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame2 = (WebSocketFrame)msg;
            this.handleWsFrame(frame2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWsFrame(WebSocketFrame msg) {
        WebSocketImplBase<?> w;
        WebSocketFrameInternal frame2 = this.decodeFrame(msg);
        WebSocketConnectionImpl webSocketConnectionImpl = this;
        synchronized (webSocketConnectionImpl) {
            w = this.webSocket;
        }
        if (frame2.isClose()) {
            this.closeReceived = true;
            if (!this.closeSent) {
                this.close(this.closeFrame(frame2.closeStatusCode(), frame2.closeReason()));
            } else if (this.server) {
                this.finishClose();
            }
        }
        if (w != null) {
            w.handleFrame(frame2);
        }
    }

    private void finishClose() {
        ScheduledFuture<?> timeout2 = this.closingTimeout;
        if (timeout2 == null || timeout2.cancel(false)) {
            this.closingTimeout = null;
            ChannelPromise p = this.closePromise;
            this.closePromise = null;
            super.handleClose(this.closeReason, p);
        }
    }

    private WebSocketFrameInternal decodeFrame(WebSocketFrame msg) {
        WebSocketFrameType frameType;
        ByteBuf payload = VertxHandler.safeBuffer(msg.content());
        boolean isFinal = msg.isFinalFragment();
        if (msg instanceof BinaryWebSocketFrame) {
            frameType = WebSocketFrameType.BINARY;
        } else if (msg instanceof CloseWebSocketFrame) {
            frameType = WebSocketFrameType.CLOSE;
        } else if (msg instanceof PingWebSocketFrame) {
            frameType = WebSocketFrameType.PING;
        } else if (msg instanceof PongWebSocketFrame) {
            frameType = WebSocketFrameType.PONG;
        } else if (msg instanceof TextWebSocketFrame) {
            frameType = WebSocketFrameType.TEXT;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            frameType = WebSocketFrameType.CONTINUATION;
        } else {
            throw new IllegalStateException("Unsupported WebSocket msg " + String.valueOf(msg));
        }
        return new WebSocketFrameImpl(frameType, payload, isFinal);
    }
}

