/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.DuplicatedContext;
import io.vertx.core.impl.EventLoopExecutor;
import io.vertx.core.impl.ExecuteBlocking;
import io.vertx.core.impl.SysProps;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.WorkerExecutor;
import io.vertx.core.impl.WorkerTaskQueue;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.EventExecutor;
import io.vertx.core.internal.WorkerPool;
import io.vertx.core.internal.deployment.DeploymentContext;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ContextImpl
extends ContextBase
implements ContextInternal {
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    static final boolean DISABLE_TIMINGS = SysProps.DISABLE_CONTEXT_TIMINGS.getBoolean();
    private final VertxImpl owner;
    private final JsonObject config;
    private final DeploymentContext deployment;
    private final CloseFuture closeFuture;
    private final ClassLoader tccl;
    private final EventLoopExecutor eventLoop;
    private final ThreadingModel threadingModel;
    private final EventExecutor executor;
    private ConcurrentMap<Object, Object> data;
    private volatile Handler<Throwable> exceptionHandler;
    final WorkerPool workerPool;
    final WorkerTaskQueue executeBlockingTasks;

    public ContextImpl(VertxImpl vertx, Object[] locals, EventLoopExecutor eventLoop, ThreadingModel threadingModel, EventExecutor executor, WorkerPool workerPool, DeploymentContext deployment, CloseFuture closeFuture, ClassLoader tccl) {
        super(locals);
        JsonObject config2 = null;
        if (deployment != null) {
            config2 = deployment.deployment().options().getConfig();
        }
        if (config2 == null) {
            config2 = new JsonObject();
        }
        this.deployment = deployment;
        this.config = config2;
        this.eventLoop = eventLoop;
        this.threadingModel = threadingModel;
        this.executor = executor;
        this.tccl = tccl;
        this.owner = vertx;
        this.workerPool = workerPool;
        this.closeFuture = closeFuture;
        this.executeBlockingTasks = new WorkerTaskQueue();
    }

    @Override
    public Future<Void> close() {
        Future<Object> fut = this.closeFuture == this.owner.closeFuture() ? Future.succeededFuture() : this.closeFuture.close();
        fut = fut.eventually(() -> Future.future(p -> this.executeBlockingTasks.shutdown(this.eventLoop.eventLoop, (Promise<Void>)p)));
        if (this.executor instanceof WorkerExecutor) {
            WorkerExecutor workerExec = (WorkerExecutor)this.executor;
            fut = fut.eventually(() -> Future.future(p -> workerExec.taskQueue().shutdown(this.eventLoop.eventLoop, (Promise<Void>)p)));
        }
        return fut;
    }

    @Override
    public DeploymentContext deployment() {
        return this.deployment;
    }

    @Override
    public CloseFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public JsonObject config() {
        return this.config;
    }

    @Override
    public EventLoop nettyEventLoop() {
        return this.eventLoop.eventLoop;
    }

    @Override
    public VertxImpl owner() {
        return this.owner;
    }

    @Override
    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return ExecuteBlocking.executeBlocking(this.workerPool, this, blockingCodeHandler, ordered ? this.executeBlockingTasks : null);
    }

    @Override
    public EventExecutor eventLoop() {
        return this.eventLoop;
    }

    @Override
    public EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isEventLoopContext() {
        return this.threadingModel() == ThreadingModel.EVENT_LOOP;
    }

    @Override
    public boolean isWorkerContext() {
        return this.threadingModel() == ThreadingModel.WORKER;
    }

    @Override
    public ThreadingModel threadingModel() {
        return this.threadingModel;
    }

    @Override
    public VertxTracer tracer() {
        return this.owner.tracer();
    }

    @Override
    public ClassLoader classLoader() {
        return this.tccl;
    }

    @Override
    public WorkerPool workerPool() {
        return this.workerPool;
    }

    @Override
    public synchronized ConcurrentMap<Object, Object> contextData() {
        if (this.data == null) {
            this.data = new ConcurrentHashMap<Object, Object>();
        }
        return this.data;
    }

    @Override
    public void reportException(Throwable t) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler == null) {
            handler = this.owner.exceptionHandler();
        }
        if (handler != null) {
            handler.handle(t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    @Override
    public Context exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public ContextInternal duplicate(boolean copy2) {
        return new DuplicatedContext(this, this.locals.length == 0 ? VertxImpl.EMPTY_CONTEXT_LOCALS : new Object[this.locals.length]);
    }
}

