/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Future;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.WorkerTask;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.WorkerPool;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class ExecuteBlocking {
    public static <T> Future<T> executeBlocking(WorkerPool workerPool, final ContextInternal context2, final Callable<T> blockingCodeHandler, TaskQueue queue) {
        final PromiseInternal promise = context2.promise();
        Future fut = promise.future();
        final PoolMetrics metrics2 = workerPool.metrics();
        final Object queueMetric = metrics2 != null ? metrics2.enqueue() : null;
        WorkerTask task = new WorkerTask(metrics2, queueMetric){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void execute() {
                Object result2;
                ContextInternal prev = context2.beginDispatch();
                try {
                    result2 = blockingCodeHandler.call();
                }
                catch (Throwable t) {
                    promise.fail(t);
                    return;
                }
                finally {
                    context2.endDispatch(prev);
                }
                promise.complete(result2);
            }

            @Override
            public void reject() {
                if (metrics2 != null) {
                    metrics2.dequeue(queueMetric);
                }
                promise.fail(new RejectedExecutionException());
            }
        };
        try {
            ExecutorService exec = workerPool.executor();
            if (queue != null) {
                queue.execute(task, exec);
            } else {
                exec.execute(task);
            }
        }
        catch (RejectedExecutionException e) {
            task.reject();
            throw e;
        }
        return fut;
    }
}

