/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Vertx;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

class SharedResourceHolder<C>
implements Shareable {
    final Hook<C> hook;
    final int count;
    final C resource;

    static <C> List<C> clearSharedResource(Vertx vertx, String resourceKey) {
        LocalMap localMap = vertx.sharedData().getLocalMap(resourceKey);
        ArrayList values2 = new ArrayList(localMap.values());
        localMap.clear();
        return values2.stream().map(sc -> sc.resource).collect(Collectors.toList());
    }

    static <R> R createSharedResource(Vertx vertx, String resourceKey, String resourceName, CloseFuture closeFuture, Function<CloseFuture, R> supplier) {
        LocalMap<String, SharedResourceHolder> localMap = vertx.sharedData().getLocalMap(resourceKey);
        SharedResourceHolder v = localMap.compute(resourceName, (key, value) -> {
            if (value == null) {
                Hook hook = new Hook(vertx, resourceKey, resourceName);
                Object resource2 = supplier.apply(hook.closeFuture);
                return new SharedResourceHolder(hook, 1, resource2);
            }
            return new SharedResourceHolder(value.hook, value.count + 1, value.resource);
        });
        Object resource2 = v.resource;
        closeFuture.add(v.hook);
        return (R)resource2;
    }

    SharedResourceHolder(Hook<C> hook, int count2, C resource2) {
        this.hook = hook;
        this.count = count2;
        this.resource = resource2;
    }

    private static class Hook<C>
    implements Closeable {
        private final Vertx vertx;
        private final CloseFuture closeFuture;
        private final String resourceKey;
        private final String resourceName;

        private Hook(Vertx vertx, String resourceKey, String resourceName) {
            this.vertx = vertx;
            this.closeFuture = new CloseFuture();
            this.resourceKey = resourceKey;
            this.resourceName = resourceName;
        }

        @Override
        public void close(Completable<Void> completion) {
            LocalMap<String, SharedResourceHolder> localMap1 = this.vertx.sharedData().getLocalMap(this.resourceKey);
            SharedResourceHolder res = localMap1.compute(this.resourceName, (key, value) -> {
                if (value == null) {
                    return null;
                }
                if (value.count == 1) {
                    return null;
                }
                return new SharedResourceHolder(this, value.count - 1, value.resource);
            });
            if (res == null) {
                this.closeFuture.close(completion);
            } else {
                completion.succeed();
            }
        }
    }
}

