/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.Completable;
import io.vertx.core.Expectation;
import io.vertx.core.VertxException;
import io.vertx.core.impl.future.Operation;
import io.vertx.core.internal.ContextInternal;

public class Expect<T>
extends Operation<T>
implements Completable<T> {
    private final Expectation<? super T> expectation;

    public Expect(ContextInternal context2, Expectation<? super T> expectation) {
        super(context2);
        this.expectation = expectation;
    }

    @Override
    public void complete(T result2, Throwable failure) {
        if (failure == null) {
            try {
                if (!this.expectation.test(result2) && (failure = this.expectation.describe(result2)) == null) {
                    failure = new VertxException("Unexpected result: " + String.valueOf(result2), true);
                }
            }
            catch (Throwable e) {
                failure = e;
            }
        }
        this.completeInternal(result2, failure);
    }
}

