/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.internal.ContextInternal;
import java.util.function.Function;

public final class FailedFuture<T>
extends FutureBase<T> {
    private final Throwable cause;

    public FailedFuture(Throwable t) {
        this(null, t);
    }

    public FailedFuture(ContextInternal context2, Throwable t) {
        super(context2);
        this.cause = t != null ? t : new NoStackTraceThrowable(null);
    }

    public FailedFuture(String failureMessage) {
        this(null, failureMessage);
    }

    public FailedFuture(ContextInternal context2, String failureMessage) {
        this(context2, new NoStackTraceThrowable(failureMessage));
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Future<T> onComplete(Handler<AsyncResult<T>> handler) {
        if (handler instanceof Completable) {
            this.emitResult(null, this.cause, (Completable)((Object)handler));
        } else if (this.context != null) {
            this.context.emit(this, handler);
        } else {
            handler.handle(this);
        }
        return this;
    }

    @Override
    public Future<T> onSuccess(Handler<? super T> handler) {
        return this;
    }

    @Override
    public Future<T> onFailure(Handler<? super Throwable> handler) {
        if (this.context != null) {
            this.context.emit(this.cause, handler);
        } else {
            handler.handle(this.cause);
        }
        return this;
    }

    @Override
    public void addListener(Completable<? super T> listener) {
        this.emitResult(null, this.cause, listener);
    }

    @Override
    public void removeListener(Completable<? super T> listener) {
    }

    @Override
    public T result() {
        return null;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public boolean succeeded() {
        return false;
    }

    @Override
    public boolean failed() {
        return true;
    }

    @Override
    public <U> Future<U> map(Function<? super T, U> mapper) {
        return this;
    }

    @Override
    public <V> Future<V> map(V value) {
        return this;
    }

    @Override
    public Future<T> otherwise(T value) {
        return new SucceededFuture<T>(this.context, value);
    }

    public String toString() {
        return "Future{cause=" + this.cause.getMessage() + "}";
    }
}

