/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.transports;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.DomainSocketAddress;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.transport.Transport;

public class EpollTransport
implements Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    @Override
    public boolean supportsDomainSockets() {
        return true;
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket()) {
            return new DomainSocketAddress(address.path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return Epoll.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return Epoll.unavailabilityCause();
    }

    @Override
    public IoHandlerFactory ioHandlerFactory() {
        return EpollIoHandler.newFactory();
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new EpollDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new EpollDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollDomainSocketChannel::new;
        }
        return EpollSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollServerDomainSocketChannel::new;
        }
        return EpollServerSocketChannel::new;
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options2) {
        channel.config().setOption(EpollChannelOption.SO_REUSEPORT, options2.isReusePort());
        Transport.super.configure(channel, options2);
    }

    @Override
    public void configure(NetServerOptions options2, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, options2.isReusePort());
            if (options2.isTcpFastOpen()) {
                bootstrap.option(ChannelOption.TCP_FASTOPEN, options2.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0);
            }
            bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, options2.isTcpQuickAck());
            bootstrap.childOption(EpollChannelOption.TCP_CORK, options2.isTcpCork());
        }
        Transport.super.configure(options2, domainSocket, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options2, int connectTimeout, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            if (options2.isTcpFastOpen()) {
                bootstrap.option(ChannelOption.TCP_FASTOPEN_CONNECT, options2.isTcpFastOpen());
            }
            bootstrap.option(EpollChannelOption.TCP_USER_TIMEOUT, options2.getTcpUserTimeout());
            bootstrap.option(EpollChannelOption.TCP_QUICKACK, options2.isTcpQuickAck());
            bootstrap.option(EpollChannelOption.TCP_CORK, options2.isTcpCork());
        }
        Transport.super.configure(options2, connectTimeout, domainSocket, bootstrap);
    }
}

