/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.verticle;

import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.impl.ServiceHelper;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.deployment.DefaultDeployment;
import io.vertx.core.impl.verticle.JavaVerticleFactory;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.deployment.Deployment;
import io.vertx.core.internal.deployment.DeploymentContext;
import io.vertx.core.internal.deployment.DeploymentManager;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.spi.VerticleFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class VerticleManager {
    private final Logger log;
    private final VertxImpl vertx;
    private final DeploymentManager deploymentManager;
    private final Map<String, List<VerticleFactory>> verticleFactories = new ConcurrentHashMap<String, List<VerticleFactory>>();
    private final List<VerticleFactory> defaultFactories = new ArrayList<VerticleFactory>();

    public VerticleManager(VertxInternal vertx, Logger log2, DeploymentManager deploymentManager) {
        this.vertx = (VertxImpl)vertx;
        this.deploymentManager = deploymentManager;
        this.log = log2;
        this.loadVerticleFactories();
    }

    private void loadVerticleFactories() {
        List<VerticleFactory> factories = ServiceHelper.loadFactories(VerticleFactory.class);
        factories.forEach(this::registerVerticleFactory);
        JavaVerticleFactory defaultFactory = new JavaVerticleFactory();
        defaultFactory.init(this.vertx);
        this.defaultFactories.add(defaultFactory);
    }

    public void registerVerticleFactory(VerticleFactory factory2) {
        String prefix = factory2.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        if (facts == null) {
            facts = new ArrayList<VerticleFactory>();
            this.verticleFactories.put(prefix, facts);
        }
        if (facts.contains(factory2)) {
            throw new IllegalArgumentException("Factory already registered");
        }
        facts.add(factory2);
        facts.sort((fact1, fact2) -> fact1.order() - fact2.order());
        factory2.init(this.vertx);
    }

    public void unregisterVerticleFactory(VerticleFactory factory2) {
        String prefix = factory2.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        boolean removed = false;
        if (facts != null) {
            if (facts.remove(factory2)) {
                removed = true;
            }
            if (facts.isEmpty()) {
                this.verticleFactories.remove(prefix);
            }
        }
        if (!removed) {
            throw new IllegalArgumentException("factory isn't registered");
        }
    }

    public Set<VerticleFactory> verticleFactories() {
        HashSet<VerticleFactory> facts = new HashSet<VerticleFactory>();
        for (List<VerticleFactory> list2 : this.verticleFactories.values()) {
            facts.addAll(list2);
        }
        return facts;
    }

    private List<VerticleFactory> resolveFactories(String identifier) {
        List<VerticleFactory> factoryList = null;
        int pos = identifier.indexOf(58);
        String lookup = null;
        if (pos != -1) {
            lookup = identifier.substring(0, pos);
        } else {
            pos = identifier.lastIndexOf(46);
            if (pos != -1) {
                lookup = VerticleManager.getSuffix(pos, identifier);
            } else {
                factoryList = this.defaultFactories;
            }
        }
        if (factoryList == null && (factoryList = this.verticleFactories.get(lookup)) == null) {
            factoryList = this.defaultFactories;
        }
        return factoryList;
    }

    private static String getSuffix(int pos, String str) {
        if (pos + 1 >= str.length()) {
            throw new IllegalArgumentException("Invalid name: " + str);
        }
        return str.substring(pos + 1);
    }

    public Future<DeploymentContext> deployVerticle(String identifier, DeploymentOptions options2) {
        ContextInternal callingContext = this.vertx.getOrCreateContext();
        ClassLoader loader = options2.getClassLoader();
        if (loader == null) {
            loader = VerticleManager.getCurrentClassLoader();
        }
        return this.deployVerticle(identifier, options2, callingContext, callingContext, loader);
    }

    private Future<DeploymentContext> deployVerticle(String identifier, DeploymentOptions options2, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        List<VerticleFactory> verticleFactories = this.resolveFactories(identifier);
        Iterator<VerticleFactory> iter = verticleFactories.iterator();
        return this.createDeployment(iter, null, identifier, options2, parentContext, callingContext, cl).compose(deployment -> this.deploymentManager.deploy(parentContext.deployment(), callingContext, (Deployment)deployment));
    }

    private Future<Deployment> createDeployment(Iterator<VerticleFactory> iter, Throwable prevErr, String identifier, DeploymentOptions options2, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        if (iter.hasNext()) {
            VerticleFactory verticleFactory = iter.next();
            return this.createDeployment(verticleFactory, identifier, options2, callingContext, cl).recover(err -> this.createDeployment(iter, (Throwable)err, identifier, options2, parentContext, callingContext, cl));
        }
        if (prevErr != null) {
            return callingContext.failedFuture(prevErr);
        }
        throw new UnsupportedOperationException();
    }

    private Future<Deployment> createDeployment(VerticleFactory verticleFactory, String identifier, DeploymentOptions options2, ContextInternal callingContext, ClassLoader cl) {
        PromiseInternal<Callable<? extends Deployable>> p = callingContext.promise();
        try {
            verticleFactory.createVerticle2(identifier, cl, p);
        }
        catch (Exception e) {
            return callingContext.failedFuture(e);
        }
        return p.future().compose(callable -> this.createDeployment(options2, (Deployable v) -> identifier, callingContext, cl, (Callable<? extends Deployable>)callable));
    }

    private Future<Deployment> createDeployment(DeploymentOptions options2, Function<Deployable, String> identifierMapper, ContextInternal callingContext, ClassLoader tccl, Callable<? extends Deployable> verticleSupplier) {
        try {
            return Future.succeededFuture(DefaultDeployment.deployment(this.vertx, this.log, options2, identifierMapper, tccl, verticleSupplier));
        }
        catch (Exception e) {
            return callingContext.failedFuture(e);
        }
    }

    private static ClassLoader getCurrentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = VerticleManager.class.getClassLoader();
        }
        return cl;
    }
}

