/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.concurrent;

import io.vertx.core.internal.EventExecutor;
import io.vertx.core.streams.impl.MessagePassingQueue;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class OutboundMessageQueue<M>
implements Predicate<M> {
    private final EventExecutor consumer;
    private final AtomicInteger numberOfUnwritableSignals = new AtomicInteger();
    private final MessagePassingQueue.MpSc<M> mqp;
    private volatile boolean eventuallyClosed;
    private boolean overflow;
    private int draining = 0;
    private boolean closed;

    public OutboundMessageQueue(EventExecutor consumer2) {
        this.consumer = consumer2;
        this.mqp = new MessagePassingQueue.MpSc(this);
    }

    public OutboundMessageQueue(EventExecutor consumer2, int lowWaterMark, int highWaterMark) {
        this.consumer = consumer2;
        this.mqp = new MessagePassingQueue.MpSc(this, lowWaterMark, highWaterMark);
    }

    @Override
    public boolean test(M msg) {
        throw new UnsupportedOperationException();
    }

    public final boolean isWritable() {
        return this.numberOfUnwritableSignals.get() <= 0;
    }

    public final boolean write(M message) {
        int flags;
        boolean inEventLoop = this.consumer.inThread();
        if (inEventLoop) {
            if (this.closed) {
                this.handleDispose(message);
                return true;
            }
            flags = this.mqp.add(message);
            if (this.draining == 0 && (flags & 4) != 0) {
                flags = this.drainMessageQueue();
            }
        } else {
            if (this.eventuallyClosed) {
                this.handleDispose(message);
                return true;
            }
            flags = this.mqp.add(message);
            if ((flags & 4) != 0) {
                this.consumer.execute(this::drain);
            }
        }
        int val = (flags & 1) != 0 ? this.numberOfUnwritableSignals.incrementAndGet() : this.numberOfUnwritableSignals.get();
        return val <= 0;
    }

    private int drainMessageQueue() {
        ++this.draining;
        try {
            int flags = this.mqp.drain();
            this.overflow |= (flags & 4) != 0;
            if ((flags & 2) != 0) {
                this.handleDrained(MessagePassingQueue.numberOfUnwritableSignals(flags));
            }
            int n = flags;
            return n;
        }
        finally {
            --this.draining;
            if (this.draining == 0 && this.closed) {
                this.releaseMessages();
            }
        }
    }

    private void drain() {
        if (this.closed) {
            return;
        }
        assert (this.draining == 0);
        this.startDraining();
        this.drainMessageQueue();
        this.stopDraining();
    }

    public final boolean tryDrain() {
        assert (this.consumer.inThread());
        if (this.overflow) {
            this.overflow = false;
            this.drain();
            return true;
        }
        return false;
    }

    public final void close() {
        assert (this.consumer.inThread());
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.eventuallyClosed = true;
        if (this.draining > 0) {
            return;
        }
        this.releaseMessages();
    }

    private void handleDrained(int numberOfSignals) {
        int val = this.numberOfUnwritableSignals.addAndGet(-numberOfSignals);
        if (val + numberOfSignals > 0 && val <= 0) {
            this.consumer.execute(this::handleDrained);
        }
    }

    private void releaseMessages() {
        List messages = this.mqp.clear();
        for (Object elt : messages) {
            this.handleDispose(elt);
        }
    }

    protected void handleDrained() {
    }

    protected void startDraining() {
    }

    protected void stopDraining() {
    }

    protected void handleDispose(M msg) {
    }
}

