/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.resource;

import io.vertx.core.Future;
import io.vertx.core.internal.resource.ManagedResource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ResourceManager<K, R extends ManagedResource> {
    private static final Consumer<ManagedResource> EXPIRED_CHECKER = ManagedResource::checkExpired;
    private final Map<K, R> resources = new ConcurrentHashMap<K, R>();
    private final AtomicInteger status = new AtomicInteger();

    public void checkExpired() {
        this.forEach(EXPIRED_CHECKER);
    }

    public void forEach(Consumer<ManagedResource> consumer2) {
        this.resources.values().forEach(consumer2);
    }

    public <T> T withResource(K key, Function<K, R> provider, BiFunction<R, Boolean, T> function) {
        ManagedResource resource2;
        this.checkStatus();
        ManagedResource[] ref = new ManagedResource[]{null};
        while (!(resource2 = this.resources.computeIfAbsent(key, k -> {
            ManagedResource r = (ManagedResource)provider.apply(key);
            r.cleaner = () -> this.resources.remove(key, ref[0]);
            ref[0] = r;
            return r;
        })).before()) {
        }
        T value = function.apply(resource2, resource2 == ref[0]);
        resource2.after();
        return value;
    }

    public <T> T withResource(K key, Function<K, R> provider, Predicate<R> checker, BiFunction<R, Boolean, T> function) {
        ManagedResource endpoint;
        this.checkStatus();
        ManagedResource[] ref = new ManagedResource[]{null};
        while (!(endpoint = this.resources.compute(key, (k, prev) -> {
            if (prev != null && checker.test(prev)) {
                return prev;
            }
            if (prev != null) {
                // empty if block
            }
            ManagedResource ep = (ManagedResource)provider.apply(key);
            ep.cleaner = () -> this.resources.remove(key, ref[0]);
            ref[0] = ep;
            return ep;
        })).before()) {
        }
        T value = function.apply(endpoint, endpoint == ref[0]);
        endpoint.after();
        return value;
    }

    public <T> Future<T> withResourceAsync(K key, Function<K, R> provider, BiFunction<R, Boolean, Future<T>> function) {
        ManagedResource endpoint;
        this.checkStatus();
        ManagedResource[] ref = new ManagedResource[]{null};
        while (!(endpoint = this.resources.computeIfAbsent(key, k -> {
            ManagedResource ep = (ManagedResource)provider.apply(key);
            ep.cleaner = () -> this.resources.remove(key, ref[0]);
            ref[0] = ep;
            return ep;
        })).before()) {
        }
        return function.apply(endpoint, endpoint == ref[0]).andThen(ar -> endpoint.after());
    }

    private void checkStatus() {
        int st = this.status.get();
        if (st == 1) {
            throw new IllegalStateException("Resource manager shutdown");
        }
        if (st == 2) {
            throw new IllegalStateException("Resource manager closed");
        }
    }

    public void shutdown() {
        if (this.status.compareAndSet(0, 1)) {
            for (ManagedResource resource2 : this.resources.values()) {
                resource2.shutdown();
            }
            this.status.set(2);
        }
    }

    public void close() {
        this.shutdown();
        if (this.status.compareAndSet(2, 3)) {
            for (ManagedResource resource2 : this.resources.values()) {
                resource2.close();
            }
            this.status.set(4);
        }
    }
}

