/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.SysProps;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.json.jackson.HybridJacksonPool;
import io.vertx.core.spi.json.JsonCodec;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class JacksonCodec
implements JsonCodec {
    private static final Logger log = LoggerFactory.getLogger(JacksonCodec.class);
    static final JsonFactory factory = JacksonCodec.buildFactory();

    private static JsonFactory buildFactory() {
        Object override;
        TSFBuilder<?, ?> tsfBuilder = JsonFactory.builder();
        StreamReadConstraints.Builder readConstraintsBuilder = StreamReadConstraints.builder();
        try {
            override = SysProps.JACKSON_DEFAULT_READ_MAX_NESTING_DEPTH.getAsInt();
            if (((OptionalInt)override).isPresent()) {
                readConstraintsBuilder.maxNestingDepth(((OptionalInt)override).getAsInt());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid " + SysProps.JACKSON_DEFAULT_READ_MAX_NESTING_DEPTH.name + " system property value, use 1000 instead");
        }
        try {
            override = SysProps.JACKSON_DEFAULT_READ_MAX_DOC_LEN.getAsLong();
            if (((OptionalLong)override).isPresent()) {
                readConstraintsBuilder.maxDocumentLength(((OptionalLong)override).getAsLong());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid " + SysProps.JACKSON_DEFAULT_READ_MAX_DOC_LEN.name + " system property value, use -1 instead");
        }
        try {
            override = SysProps.JACKSON_DEFAULT_READ_MAX_NUM_LEN.getAsInt();
            if (((OptionalInt)override).isPresent()) {
                readConstraintsBuilder.maxNumberLength(((OptionalInt)override).getAsInt());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid " + SysProps.JACKSON_DEFAULT_READ_MAX_NUM_LEN.name + " system property value, use 1000 instead");
        }
        try {
            override = SysProps.JACKSON_DEFAULT_READ_MAX_STRING_LEN.getAsInt();
            if (((OptionalInt)override).isPresent()) {
                readConstraintsBuilder.maxStringLength(((OptionalInt)override).getAsInt());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid " + SysProps.JACKSON_DEFAULT_READ_MAX_STRING_LEN.name + " system property value, use 20000000 instead");
        }
        try {
            override = SysProps.JACKSON_DEFAULT_READ_MAX_NAME_LEN.getAsInt();
            if (((OptionalInt)override).isPresent()) {
                readConstraintsBuilder.maxNameLength(((OptionalInt)override).getAsInt());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid " + SysProps.JACKSON_DEFAULT_READ_MAX_NAME_LEN.name + " system property value, use 50000 instead");
        }
        try {
            override = SysProps.JACKSON_DEFAULT_READ_MAX_TOKEN_COUNT.getAsLong();
            if (((OptionalLong)override).isPresent()) {
                readConstraintsBuilder.maxTokenCount(((OptionalLong)override).getAsLong());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid " + SysProps.JACKSON_DEFAULT_READ_MAX_TOKEN_COUNT.name + " system property value, use -1 instead");
        }
        tsfBuilder.streamReadConstraints(readConstraintsBuilder.build());
        tsfBuilder.recyclerPool(HybridJacksonPool.getInstance());
        return tsfBuilder.build();
    }

    @Override
    public <T> T fromString(String json2, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json2), clazz);
    }

    @Override
    public <T> T fromBuffer(Buffer json2, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json2), clazz);
    }

    @Override
    public <T> T fromValue(Object json2, Class<T> toValueType) {
        throw new DecodeException("Mapping " + toValueType.getName() + "  is not available without Jackson Databind on the classpath");
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        BufferRecycler br = factory._getBufferRecycler();
        try {
            SegmentedStringWriter sw = new SegmentedStringWriter(br);
            try {
                JsonGenerator generator = JacksonCodec.createGenerator(sw, pretty);
                JacksonCodec.encodeJson(object, generator);
                generator.close();
                String string = sw.getAndClear();
                sw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        sw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EncodeException(e.getMessage(), e);
                }
            }
        }
        finally {
            br.releaseToPool();
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        BufferRecycler br = factory._getBufferRecycler();
        try {
            ByteArrayBuilder bb = new ByteArrayBuilder(br);
            try {
                JsonGenerator generator = JacksonCodec.createGenerator(bb, pretty);
                JacksonCodec.encodeJson(object, generator);
                generator.close();
                byte[] result2 = bb.toByteArray();
                bb.release();
                Buffer buffer = Buffer.buffer(result2);
                bb.close();
                return buffer;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bb.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EncodeException(e.getMessage(), e);
                }
            }
        }
        finally {
            br.releaseToPool();
        }
    }

    public static JsonParser createParser(String str) {
        try {
            return factory.createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static JsonParser createParser(Buffer buf) {
        try {
            return factory.createParser(new ByteBufInputStream(((BufferInternal)buf).getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonGenerator createGenerator(Writer out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonGenerator createGenerator(OutputStream out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public Object fromString(String str) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str), Object.class);
    }

    public Object fromBuffer(Buffer buf) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), Object.class);
    }

    public static <T> T fromParser(JsonParser parser, Class<T> type2) throws DecodeException {
        JsonToken remaining;
        Object res;
        try {
            parser.nextToken();
            res = JacksonCodec.parseAny(parser);
            remaining = parser.nextToken();
        }
        catch (IOException e) {
            throw new DecodeException(e.getMessage(), e);
        }
        finally {
            JacksonCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        return JacksonCodec.cast(res, type2);
    }

    private static Object parseAny(JsonParser parser) throws IOException, DecodeException {
        switch (parser.currentTokenId()) {
            case 1: {
                return JacksonCodec.parseObject(parser);
            }
            case 3: {
                return JacksonCodec.parseArray(parser);
            }
            case 6: {
                return parser.getText();
            }
            case 7: 
            case 8: {
                return parser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        throw new DecodeException("Unexpected token");
    }

    private static Map<String, Object> parseObject(JsonParser parser) throws IOException {
        String key1 = parser.nextFieldName();
        if (key1 == null) {
            return new LinkedHashMap<String, Object>(2);
        }
        parser.nextToken();
        Object value1 = JacksonCodec.parseAny(parser);
        String key2 = parser.nextFieldName();
        if (key2 == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            return obj;
        }
        parser.nextToken();
        Object value2 = JacksonCodec.parseAny(parser);
        String key = parser.nextFieldName();
        if (key == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            obj.put(key2, value2);
            return obj;
        }
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put(key1, value1);
        obj.put(key2, value2);
        do {
            parser.nextToken();
            Object value = JacksonCodec.parseAny(parser);
            obj.put(key, value);
        } while ((key = parser.nextFieldName()) != null);
        return obj;
    }

    private static List<Object> parseArray(JsonParser parser) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            parser.nextToken();
            int tokenId = parser.currentTokenId();
            if (tokenId == 5) {
                throw new UnsupportedOperationException();
            }
            if (tokenId == 4) {
                return array;
            }
            Object value = JacksonCodec.parseAny(parser);
            array.add(value);
        }
    }

    static void close(Closeable parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void encodeJson(Object json2, JsonGenerator generator) throws EncodeException {
        try {
            if (json2 instanceof JsonObject) {
                json2 = ((JsonObject)json2).getMap();
            } else if (json2 instanceof JsonArray) {
                json2 = ((JsonArray)json2).getList();
            }
            if (json2 instanceof Map) {
                generator.writeStartObject();
                for (Map.Entry e : ((Map)json2).entrySet()) {
                    generator.writeFieldName((String)e.getKey());
                    Object value = e.getValue();
                    JacksonCodec.encodeJson0(value, generator);
                }
                generator.writeEndObject();
            } else if (json2 instanceof List) {
                generator.writeStartArray();
                for (Object item2 : (List)json2) {
                    JacksonCodec.encodeJson0(item2, generator);
                }
                generator.writeEndArray();
            } else if (!JacksonCodec.encodeSingleType(generator, json2)) {
                throw new EncodeException("Mapping " + json2.getClass().getName() + "  is not available without Jackson Databind on the classpath");
            }
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage(), e);
        }
    }

    private static void encodeJson0(Object json2, JsonGenerator generator) throws EncodeException {
        try {
            if (json2 instanceof JsonObject) {
                json2 = ((JsonObject)json2).getMap();
            } else if (json2 instanceof JsonArray) {
                json2 = ((JsonArray)json2).getList();
            }
            if (json2 instanceof Map) {
                generator.writeStartObject();
                for (Map.Entry e : ((Map)json2).entrySet()) {
                    generator.writeFieldName((String)e.getKey());
                    Object value = e.getValue();
                    JacksonCodec.encodeJson(value, generator);
                }
                generator.writeEndObject();
            } else if (json2 instanceof List) {
                generator.writeStartArray();
                for (Object item2 : (List)json2) {
                    JacksonCodec.encodeJson(item2, generator);
                }
                generator.writeEndArray();
            } else if (!JacksonCodec.encodeSingleType(generator, json2)) {
                throw new EncodeException("Mapping " + json2.getClass().getName() + "  is not available without Jackson Databind on the classpath");
            }
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage(), e);
        }
    }

    private static boolean encodeSingleType(JsonGenerator generator, Object json2) throws IOException {
        if (json2 == null) {
            generator.writeNull();
        } else if (json2 instanceof String) {
            generator.writeString((String)json2);
        } else if (json2 instanceof Number) {
            JacksonCodec.encodeNumber(generator, json2);
        } else if (json2 instanceof Boolean) {
            generator.writeBoolean((Boolean)json2);
        } else if (json2 instanceof Instant) {
            generator.writeString(DateTimeFormatter.ISO_INSTANT.format((Instant)json2));
        } else if (json2 instanceof byte[]) {
            generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString((byte[])json2));
        } else if (json2 instanceof Buffer) {
            generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)json2).getBytes()));
        } else if (json2 instanceof Enum) {
            generator.writeString(((Enum)json2).name());
        } else {
            return false;
        }
        return true;
    }

    private static void encodeNumber(JsonGenerator generator, Object json2) throws IOException {
        if (json2 instanceof Short) {
            generator.writeNumber((Short)json2);
        } else if (json2 instanceof Integer) {
            generator.writeNumber((Integer)json2);
        } else if (json2 instanceof Long) {
            generator.writeNumber((Long)json2);
        } else if (json2 instanceof Float) {
            generator.writeNumber(((Float)json2).floatValue());
        } else if (json2 instanceof Double) {
            generator.writeNumber((Double)json2);
        } else if (json2 instanceof Byte) {
            generator.writeNumber(((Byte)json2).byteValue());
        } else if (json2 instanceof BigInteger) {
            generator.writeNumber((BigInteger)json2);
        } else if (json2 instanceof BigDecimal) {
            generator.writeNumber((BigDecimal)json2);
        } else {
            generator.writeNumber(((Number)json2).doubleValue());
        }
    }

    private static <T> T cast(Object o, Class<T> clazz) {
        if (o instanceof Map) {
            if (!clazz.isAssignableFrom(Map.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonObject((Map)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof List) {
            if (!clazz.isAssignableFrom(List.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonArray((List)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof String) {
            String str = (String)o;
            if (clazz.isEnum()) {
                o = Enum.valueOf(clazz, str);
            } else if (clazz == byte[].class) {
                o = JsonUtil.BASE64_DECODER.decode(str);
            } else if (clazz == Buffer.class) {
                o = Buffer.buffer(JsonUtil.BASE64_DECODER.decode(str));
            } else if (clazz == Instant.class) {
                o = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(str));
            } else if (!clazz.isAssignableFrom(String.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o instanceof Boolean) {
            if (!clazz.isAssignableFrom(Boolean.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o == null) {
            return null;
        }
        Number number = (Number)o;
        if (clazz == Integer.class) {
            o = number.intValue();
        } else if (clazz == Long.class) {
            o = number.longValue();
        } else if (clazz == Float.class) {
            o = Float.valueOf(number.floatValue());
        } else if (clazz == Double.class) {
            o = number.doubleValue();
        } else if (clazz == Byte.class) {
            o = number.byteValue();
        } else if (clazz == Short.class) {
            o = number.shortValue();
        } else if (clazz != Object.class && !clazz.isAssignableFrom(Number.class)) {
            throw new DecodeException("Failed to decode");
        }
        return clazz.cast(o);
    }

    static {
        factory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

