/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.spi.logging.LogDelegate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JULLogDelegate
implements LogDelegate {
    private final Logger logger;

    JULLogDelegate(String name) {
        this.logger = Logger.getLogger(name);
    }

    @Override
    public String implementation() {
        return "jul";
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void error(Object message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARNING, message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public void debug(Object message) {
        this.log(Level.FINE, message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.FINEST, message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(Level.FINEST, message, t);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Level level, Object message, Throwable t) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        String msg = message == null ? "NULL" : message.toString();
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.logger.getName());
        if (t != null) {
            record.setThrown(t);
        }
        record.setSourceClassName(null);
        this.logger.log(record);
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

