/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.ProxyOptions;
import java.util.ArrayList;
import java.util.Map;

public class ClientOptionsBaseConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, ClientOptionsBase obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "trustAll": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTrustAll((Boolean)member.getValue());
                    break;
                }
                case "connectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setConnectTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "metricsName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMetricsName((String)member.getValue());
                    break;
                }
                case "proxyOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setProxyOptions(new ProxyOptions((JsonObject)member.getValue()));
                    break;
                }
                case "nonProxyHosts": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list2 = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setNonProxyHosts(list2);
                    break;
                }
                case "localAddress": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLocalAddress((String)member.getValue());
                }
            }
        }
    }

    static void toJson(ClientOptionsBase obj, JsonObject json2) {
        ClientOptionsBaseConverter.toJson(obj, json2.getMap());
    }

    static void toJson(ClientOptionsBase obj, Map<String, Object> json2) {
        json2.put("trustAll", obj.isTrustAll());
        json2.put("connectTimeout", obj.getConnectTimeout());
        if (obj.getMetricsName() != null) {
            json2.put("metricsName", obj.getMetricsName());
        }
        if (obj.getProxyOptions() != null) {
            json2.put("proxyOptions", obj.getProxyOptions().toJson());
        }
        if (obj.getNonProxyHosts() != null) {
            JsonArray array = new JsonArray();
            obj.getNonProxyHosts().forEach(item2 -> array.add(item2));
            json2.put("nonProxyHosts", array);
        }
        if (obj.getLocalAddress() != null) {
            json2.put("localAddress", obj.getLocalAddress());
        }
    }
}

