/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;

@DataObject
public class ConnectOptions {
    public static final boolean DEFAULT_SSL = false;
    private String host;
    private Integer port;
    private String sniServerName;
    private SocketAddress remoteAddress;
    private ProxyOptions proxyOptions;
    private boolean ssl;
    private ClientSSLOptions sslOptions;
    private int timeout;

    public ConnectOptions() {
        this.host = null;
        this.port = null;
        this.sniServerName = null;
        this.remoteAddress = null;
        this.proxyOptions = null;
        this.ssl = false;
        this.sslOptions = null;
        this.timeout = -1;
    }

    public ConnectOptions(ConnectOptions other) {
        this.host = other.getHost();
        this.port = other.getPort();
        this.sniServerName = other.getSniServerName();
        this.remoteAddress = other.getRemoteAddress();
        this.proxyOptions = other.getProxyOptions() != null ? new ProxyOptions(other.getProxyOptions()) : null;
        this.ssl = other.isSsl();
        this.sslOptions = other.getSslOptions() != null ? new ClientSSLOptions(other.getSslOptions()) : null;
        this.timeout = other.getTimeout();
    }

    public String getHost() {
        return this.host;
    }

    public ConnectOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public ConnectOptions setPort(Integer port) {
        this.port = port;
        return this;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public ConnectOptions setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public String getSniServerName() {
        return this.sniServerName;
    }

    public ConnectOptions setSniServerName(String sniServerName) {
        this.sniServerName = sniServerName;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public ConnectOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public ConnectOptions setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public ClientSSLOptions getSslOptions() {
        return this.sslOptions;
    }

    public ConnectOptions setSslOptions(ClientSSLOptions sslOptions) {
        this.sslOptions = sslOptions;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ConnectOptions setTimeout(int timeout2) {
        if (timeout2 < -2) {
            throw new IllegalArgumentException("connectTimeout must be >= 0 or -1 (use default client value)");
        }
        this.timeout = timeout2;
        return this;
    }
}

