/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SSLOptions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SSLOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json2, SSLOptions obj) {
        for (Map.Entry<String, Object> member : json2) {
            switch (member.getKey()) {
                case "enabledCipherSuites": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            obj.addEnabledCipherSuite((String)item2);
                        }
                    });
                    break;
                }
                case "crlPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            obj.addCrlPath((String)item2);
                        }
                    });
                    break;
                }
                case "crlValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            obj.addCrlValue(Buffer.fromJson((String)item2));
                        }
                    });
                    break;
                }
                case "useAlpn": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseAlpn((Boolean)member.getValue());
                    break;
                }
                case "enabledSecureTransportProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list2 = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setEnabledSecureTransportProtocols(list2);
                    break;
                }
                case "sslHandshakeTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSslHandshakeTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "sslHandshakeTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSslHandshakeTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "applicationLayerProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list2 = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list2.add((String)item2);
                        }
                    });
                    obj.setApplicationLayerProtocols((List<String>)((Object)list2));
                }
            }
        }
    }

    static void toJson(SSLOptions obj, JsonObject json2) {
        SSLOptionsConverter.toJson(obj, json2.getMap());
    }

    static void toJson(SSLOptions obj, Map<String, Object> json2) {
        JsonArray array;
        if (obj.getEnabledCipherSuites() != null) {
            array = new JsonArray();
            obj.getEnabledCipherSuites().forEach(item2 -> array.add(item2));
            json2.put("enabledCipherSuites", array);
        }
        if (obj.getCrlPaths() != null) {
            array = new JsonArray();
            obj.getCrlPaths().forEach(item2 -> array.add(item2));
            json2.put("crlPaths", array);
        }
        if (obj.getCrlValues() != null) {
            array = new JsonArray();
            obj.getCrlValues().forEach(item2 -> array.add(item2.toJson()));
            json2.put("crlValues", array);
        }
        json2.put("useAlpn", obj.isUseAlpn());
        if (obj.getEnabledSecureTransportProtocols() != null) {
            array = new JsonArray();
            obj.getEnabledSecureTransportProtocols().forEach(item2 -> array.add(item2));
            json2.put("enabledSecureTransportProtocols", array);
        }
        json2.put("sslHandshakeTimeout", obj.getSslHandshakeTimeout());
        if (obj.getSslHandshakeTimeoutUnit() != null) {
            json2.put("sslHandshakeTimeoutUnit", obj.getSslHandshakeTimeoutUnit().name());
        }
        if (obj.getApplicationLayerProtocols() != null) {
            array = new JsonArray();
            obj.getApplicationLayerProtocols().forEach(item2 -> array.add(item2));
            json2.put("applicationLayerProtocols", array);
        }
    }
}

