/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.ServerSSLOptionsConverter;
import io.vertx.core.net.TrustOptions;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public class ServerSSLOptions
extends SSLOptions {
    public static final ClientAuth DEFAULT_CLIENT_AUTH = ClientAuth.NONE;
    public static final boolean DEFAULT_SNI = false;
    private ClientAuth clientAuth;
    private boolean sni;

    public ServerSSLOptions() {
    }

    public ServerSSLOptions(ServerSSLOptions other) {
        super(other);
        this.clientAuth = other.clientAuth;
        this.sni = other.sni;
    }

    public ServerSSLOptions(JsonObject json2) {
        super(json2);
        ServerSSLOptionsConverter.fromJson(json2, this);
    }

    @Override
    protected void init() {
        super.init();
        this.clientAuth = DEFAULT_CLIENT_AUTH;
        this.sni = false;
    }

    @Override
    public ServerSSLOptions copy() {
        return new ServerSSLOptions(this);
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public ServerSSLOptions setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    public boolean isSni() {
        return this.sni;
    }

    public ServerSSLOptions setSni(boolean sni) {
        this.sni = sni;
        return this;
    }

    @Override
    public ServerSSLOptions setKeyCertOptions(KeyCertOptions options2) {
        return (ServerSSLOptions)super.setKeyCertOptions(options2);
    }

    @Override
    public ServerSSLOptions setTrustOptions(TrustOptions options2) {
        return (ServerSSLOptions)super.setTrustOptions(options2);
    }

    @Override
    public ServerSSLOptions setUseAlpn(boolean useAlpn) {
        return (ServerSSLOptions)super.setUseAlpn(useAlpn);
    }

    @Override
    public ServerSSLOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        return (ServerSSLOptions)super.setSslHandshakeTimeout(sslHandshakeTimeout);
    }

    @Override
    public ServerSSLOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        return (ServerSSLOptions)super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
    }

    @Override
    public ServerSSLOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return (ServerSSLOptions)super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    @Override
    public ServerSSLOptions setApplicationLayerProtocols(List<String> protocols) {
        return (ServerSSLOptions)super.setApplicationLayerProtocols(protocols);
    }

    @Override
    public ServerSSLOptions addEnabledCipherSuite(String suite) {
        return (ServerSSLOptions)super.addEnabledCipherSuite(suite);
    }

    @Override
    public ServerSSLOptions addCrlPath(String crlPath) throws NullPointerException {
        return (ServerSSLOptions)super.addCrlPath(crlPath);
    }

    @Override
    public ServerSSLOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (ServerSSLOptions)super.addCrlValue(crlValue);
    }

    @Override
    public ServerSSLOptions addEnabledSecureTransportProtocol(String protocol) {
        return (ServerSSLOptions)super.addEnabledSecureTransportProtocol(protocol);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json2 = super.toJson();
        ServerSSLOptionsConverter.toJson(this, json2);
        return json2;
    }
}

