/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.endpoint;

import io.vertx.core.net.endpoint.DefaultInteractionMetrics;
import io.vertx.core.net.endpoint.InteractionMetrics;
import io.vertx.core.net.endpoint.ServerEndpoint;
import io.vertx.core.net.endpoint.ServerSelector;
import io.vertx.core.net.endpoint.impl.ConsistentHashingSelector;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public interface LoadBalancer {
    public static final LoadBalancer ROUND_ROBIN = servers -> {
        AtomicInteger idx = new AtomicInteger();
        return () -> {
            if (servers.isEmpty()) {
                return -1;
            }
            int next2 = idx.getAndIncrement();
            return next2 % servers.size();
        };
    };
    public static final LoadBalancer LEAST_REQUESTS = servers -> () -> {
        int numberOfRequests = Integer.MAX_VALUE;
        int selected = -1;
        int idx = 0;
        for (ServerEndpoint node : servers) {
            int val = ((DefaultInteractionMetrics)node.metrics()).numberOfInflightRequests();
            if (val < numberOfRequests) {
                numberOfRequests = val;
                selected = idx;
            }
            ++idx;
        }
        return selected;
    };
    public static final LoadBalancer RANDOM = servers -> () -> {
        if (servers.isEmpty()) {
            return -1;
        }
        return ThreadLocalRandom.current().nextInt(servers.size());
    };
    public static final LoadBalancer POWER_OF_TWO_CHOICES = servers -> () -> {
        if (servers.isEmpty()) {
            return -1;
        }
        if (servers.size() == 1) {
            return 0;
        }
        int i1 = ThreadLocalRandom.current().nextInt(servers.size());
        int i2 = ThreadLocalRandom.current().nextInt(servers.size());
        while (i2 == i1) {
            i2 = ThreadLocalRandom.current().nextInt(servers.size());
        }
        if (((DefaultInteractionMetrics)((ServerEndpoint)servers.get(i1)).metrics()).numberOfInflightRequests() < ((DefaultInteractionMetrics)((ServerEndpoint)servers.get(i2)).metrics()).numberOfInflightRequests()) {
            return i1;
        }
        return i2;
    };
    public static final LoadBalancer CONSISTENT_HASHING = LoadBalancer.consistentHashing(4, RANDOM);

    default public InteractionMetrics<?> newMetrics() {
        return new DefaultInteractionMetrics();
    }

    public static LoadBalancer consistentHashing(int numberOfVirtualServers, LoadBalancer fallback) {
        return servers -> {
            ServerSelector fallbackSelector = fallback.selector(servers);
            return new ConsistentHashingSelector(servers, numberOfVirtualServers, fallbackSelector);
        };
    }

    public ServerSelector selector(List<? extends ServerEndpoint> var1);
}

