/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.endpoint.impl;

import io.vertx.core.net.endpoint.ServerEndpoint;
import io.vertx.core.net.endpoint.ServerSelector;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHashingSelector
implements ServerSelector {
    private final List<? extends ServerEndpoint> endpoints;
    private final SortedMap<Long, ServerEndpoint> nodes;
    private final ServerSelector fallbackSelector;

    public ConsistentHashingSelector(List<? extends ServerEndpoint> endpoints, int numberOfVirtualNodes, ServerSelector fallbackSelector) {
        MessageDigest instance;
        try {
            instance = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        TreeMap<Long, ServerEndpoint> ring = new TreeMap<Long, ServerEndpoint>();
        for (ServerEndpoint serverEndpoint : endpoints) {
            for (int idx = 0; idx < numberOfVirtualNodes; ++idx) {
                String nodeId = serverEndpoint.key() + "-" + idx;
                long hash = ConsistentHashingSelector.hash(instance, nodeId.getBytes(StandardCharsets.UTF_8));
                ring.put(hash, serverEndpoint);
            }
        }
        this.nodes = ring;
        this.endpoints = endpoints;
        this.fallbackSelector = fallbackSelector;
    }

    private static long hash(MessageDigest md, byte[] data2) {
        md.reset();
        md.update(data2);
        byte[] digest = md.digest();
        byte b0 = (byte)(digest[0] ^ digest[8]);
        byte b1 = (byte)(digest[1] ^ digest[9]);
        byte b2 = (byte)(digest[2] ^ digest[10]);
        byte b3 = (byte)(digest[3] ^ digest[11]);
        byte b4 = (byte)(digest[4] ^ digest[12]);
        byte b5 = (byte)(digest[5] ^ digest[13]);
        byte b6 = (byte)(digest[6] ^ digest[14]);
        byte b7 = (byte)(digest[7] ^ digest[15]);
        return (long)b0 << 56 | (long)b1 << 48 | (long)b2 << 40 | (long)b3 << 32 | (long)b4 << 24 | (long)b5 << 16 | (long)b6 << 8 | (long)b7;
    }

    @Override
    public int select() {
        return this.fallbackSelector.select();
    }

    @Override
    public int select(String key) {
        MessageDigest md;
        if (key == null) {
            throw new NullPointerException("No null routing key accepted");
        }
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        long hash = ConsistentHashingSelector.hash(md, key.getBytes(StandardCharsets.UTF_8));
        SortedMap<Long, ServerEndpoint> map2 = this.nodes.tailMap(hash);
        Long val = map2.isEmpty() ? this.nodes.firstKey() : map2.firstKey();
        ServerEndpoint endpoint = (ServerEndpoint)this.nodes.get(val);
        return this.endpoints.indexOf(endpoint);
    }
}

