/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.AbstractFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.FutureBase;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class DelegatingChannelPromise
extends AbstractFuture<Void>
implements ChannelPromise {
    private ChannelPromise bridge;
    private final Channel channel;
    private final Promise<Void> promise;

    DelegatingChannelPromise(Promise<Void> promise, Channel channel) {
        this.channel = Objects.requireNonNull(channel);
        this.promise = Objects.requireNonNull(promise);
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPromise setSuccess(Void result2) {
        return this.setSuccess();
    }

    @Override
    public ChannelPromise setSuccess() {
        this.promise.succeed();
        return this;
    }

    @Override
    public boolean trySuccess() {
        return this.promise.tryComplete();
    }

    @Override
    public ChannelPromise setFailure(Throwable cause) {
        this.promise.tryFail(cause);
        return this;
    }

    @Override
    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        this.bridge().addListeners(new GenericFutureListener[]{listener});
        return this;
    }

    @Override
    public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners2) {
        this.bridge().addListeners((GenericFutureListener[])listeners2);
        return this;
    }

    @Override
    public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        this.bridge().removeListeners(new GenericFutureListener[]{listener});
        return this;
    }

    @Override
    public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners2) {
        this.bridge().removeListeners((GenericFutureListener[])listeners2);
        return this;
    }

    @Override
    public ChannelPromise sync() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelPromise syncUninterruptibly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelPromise await() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelPromise awaitUninterruptibly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelPromise unvoid() {
        return this;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public boolean trySuccess(Void result2) {
        return this.promise.tryComplete();
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.promise.tryFail(cause);
    }

    @Override
    public boolean setUncancellable() {
        return true;
    }

    @Override
    public boolean isSuccess() {
        return this.promise.future().succeeded();
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public Throwable cause() {
        return this.promise.future().cause();
    }

    @Override
    public boolean await(long timeout2, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitUninterruptibly(long timeout2, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Void getNow() {
        return null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.promise.future().isComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelPromise bridge() {
        ChannelPromise p;
        DelegatingChannelPromise delegatingChannelPromise = this;
        synchronized (delegatingChannelPromise) {
            p = this.bridge;
            if (p == null) {
                ChannelPromise pr;
                p = pr = this.channel.newPromise();
                ((FutureBase)this.promise.future()).addListener((? super T result2, Throwable failure) -> {
                    if (failure == null) {
                        pr.setSuccess();
                    } else {
                        pr.setFailure(failure);
                    }
                });
                this.bridge = p;
            }
        }
        return p;
    }
}

