/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.impl.EventLoopExecutor;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.concurrent.OutboundMessageQueue;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.MessageWrite;
import io.vertx.core.net.impl.ShutdownEvent;
import io.vertx.core.spi.metrics.Metrics;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class VertxConnection
extends ConnectionBase {
    private static final Logger log = LoggerFactory.getLogger(VertxConnection.class);
    private static final int MAX_REGION_SIZE = 0x100000;
    public final VoidChannelPromise voidPromise;
    private final OutboundWriteQueue outboundMessageQueue;
    private Handler<Void> shutdownHandler;
    private Deque<Object> pending;
    private boolean reentrant;
    private boolean read;
    private boolean needsFlush;
    private boolean draining;
    private boolean channelWritable;
    private boolean paused;
    private boolean autoRead;
    private ScheduledFuture<?> shutdownTimeout;

    public VertxConnection(ContextInternal context2, ChannelHandlerContext chctx) {
        this(context2, chctx, false);
    }

    public VertxConnection(ContextInternal context2, ChannelHandlerContext chctx, boolean strictThreadMode) {
        super(context2, chctx);
        EventLoopExecutor executor = context2.threadingModel() == ThreadingModel.EVENT_LOOP ? (EventLoopExecutor)context2.executor() : new EventLoopExecutor(context2.nettyEventLoop());
        this.channelWritable = chctx.channel().isWritable();
        this.outboundMessageQueue = strictThreadMode ? new DirectOutboundMessageQueue() : new InternalMessageChannel(executor);
        this.voidPromise = new VoidChannelPromise(chctx.channel(), false);
        this.autoRead = true;
    }

    public synchronized ConnectionBase shutdownHandler(@Nullable Handler<Void> handler) {
        this.shutdownHandler = handler;
        return this;
    }

    public final Future<Void> shutdown(long timeout2, TimeUnit unit) {
        return this.shutdown(null, timeout2, unit);
    }

    public final Future<Void> shutdown(Object reason, long timeout2, TimeUnit unit) {
        PromiseInternal<Void> promise = this.vertx.promise();
        EventExecutor eventLoop = this.chctx.executor();
        if (eventLoop.inEventLoop()) {
            this.shutdown(reason, timeout2, unit, promise);
        } else {
            eventLoop.execute(() -> this.shutdown(reason, timeout2, unit, promise));
        }
        return promise.future();
    }

    private void shutdown(Object reason, long timeout2, TimeUnit unit, Promise<Void> promise) {
        this.close(reason, timeout2, unit).onComplete(promise);
    }

    protected void handleEvent(Object event) {
        if (event instanceof ShutdownEvent) {
            ShutdownEvent shutdown = (ShutdownEvent)event;
            this.shutdown(shutdown.timeout(), shutdown.timeUnit());
        } else {
            ReferenceCountUtil.release(event);
        }
    }

    protected void handleIdle(IdleStateEvent event) {
        log.debug("The connection will be closed due to timeout");
        this.chctx.close();
    }

    protected boolean supportsFileRegion() {
        return this.vertx.transport().supportFileRegion() && !this.isSsl() && !this.isTrafficShaped();
    }

    protected void handleShutdown(Object reason, long timeout2, TimeUnit unit, ChannelPromise promise) {
        ScheduledFuture<?> t = this.shutdownTimeout;
        if (t != null) {
            this.shutdownTimeout = null;
            t.cancel(false);
            super.handleClose(reason, 0L, TimeUnit.SECONDS, promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void handleClose(Object reason, long timeout2, TimeUnit unit, ChannelPromise promise) {
        if (timeout2 == 0L) {
            super.handleClose(reason, timeout2, unit, promise);
        } else {
            Handler<Void> handler;
            EventExecutor el = this.chctx.executor();
            this.shutdownTimeout = el.schedule(() -> {
                this.shutdownTimeout = null;
                super.handleClose(reason, 0L, TimeUnit.SECONDS, promise);
            }, timeout2, unit);
            VertxConnection vertxConnection = this;
            synchronized (vertxConnection) {
                handler = this.shutdownHandler;
            }
            if (handler != null) {
                this.context.emit(handler);
            }
            this.handleShutdown(reason, timeout2, unit, promise);
        }
    }

    @Override
    protected void handleClose(Object reason, ChannelPromise promise) {
        this.writeClose(promise);
    }

    @Override
    protected void handleClosed() {
        ScheduledFuture<?> timeout2 = this.shutdownTimeout;
        if (timeout2 != null) {
            this.shutdownTimeout = null;
            timeout2.cancel(false);
        }
        this.outboundMessageQueue.close();
        super.handleClosed();
    }

    protected void handleWriteQueueDrained() {
    }

    protected void handleMessage(Object msg) {
    }

    protected void handleReadComplete() {
    }

    void channelWritabilityChanged() {
        this.channelWritable = this.chctx.channel().isWritable();
        if (this.channelWritable) {
            this.outboundMessageQueue.tryDrain();
        }
    }

    final void read(Object msg) {
        if (Metrics.METRICS_ENABLED) {
            this.reportBytesRead(msg);
        }
        this.read = true;
        if (!(this.reentrant || this.paused || this.pending != null && !this.pending.isEmpty())) {
            this.reentrant = true;
            try {
                this.handleMessage(msg);
            }
            finally {
                this.reentrant = false;
            }
        } else {
            this.addPending(msg);
        }
    }

    private void addPending(Object msg) {
        if (this.pending == null) {
            this.pending = new ArrayDeque<Object>();
        }
        this.pending.add(msg);
        if (!this.reentrant) {
            this.checkPendingMessages();
        }
    }

    final void readComplete() {
        if (this.read) {
            if (this.pending != null) {
                this.checkPendingMessages();
            }
            this.handleReadComplete();
            this.read = false;
            this.checkFlush();
            this.checkAutoRead();
        }
    }

    private void checkPendingMessages() {
        this.reentrant = true;
        try {
            Object msg;
            while (!this.paused && (msg = this.pending.poll()) != null) {
                this.handleMessage(msg);
            }
        }
        finally {
            this.reentrant = false;
        }
    }

    public final void doPause() {
        assert (this.chctx.executor().inEventLoop());
        this.paused = true;
    }

    public final void doResume() {
        assert (this.chctx.executor().inEventLoop());
        if (!this.paused) {
            return;
        }
        this.paused = false;
        if (!this.read && this.pending != null && !this.pending.isEmpty()) {
            this.read = true;
            try {
                this.checkPendingMessages();
                this.handleReadComplete();
            }
            finally {
                this.read = false;
                if (!this.draining) {
                    this.checkFlush();
                }
                this.checkAutoRead();
            }
        }
    }

    private void checkFlush() {
        if (this.needsFlush) {
            this.needsFlush = false;
            this.chctx.flush();
        }
    }

    private void checkAutoRead() {
        if (this.autoRead) {
            if (this.pending != null && this.pending.size() >= 8) {
                this.autoRead = false;
                this.chctx.channel().config().setAutoRead(false);
            }
        } else if (this.pending == null || this.pending.isEmpty()) {
            this.autoRead = true;
            this.chctx.channel().config().setAutoRead(true);
        }
    }

    public final ChannelPromise write(Object msg, boolean forceFlush, Promise<Void> promise) {
        ChannelPromise channelPromise = promise == null ? this.voidPromise : this.newChannelPromise(promise);
        this.write(msg, forceFlush, channelPromise);
        return channelPromise;
    }

    public final ChannelPromise write(Object msg, boolean forceFlush) {
        return this.write(msg, forceFlush, this.voidPromise);
    }

    public final ChannelPromise write(Object msg, boolean forceFlush, ChannelPromise promise) {
        assert (this.chctx.executor().inEventLoop());
        if (Metrics.METRICS_ENABLED) {
            this.reportsBytesWritten(msg);
        }
        boolean flush2 = !this.read && !this.draining || forceFlush;
        boolean bl = this.needsFlush = !flush2;
        if (flush2) {
            this.chctx.writeAndFlush(msg, promise);
        } else {
            this.chctx.write(msg, promise);
        }
        return promise;
    }

    private void writeClose(ChannelPromise promise) {
        ChannelFuture channelPromise = this.chctx.newPromise().addListener(f -> this.chctx.close(promise));
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, (ChannelPromise)channelPromise);
    }

    public final boolean writeToChannel(Object obj) {
        return this.writeToChannel(obj, this.voidPromise);
    }

    public final boolean writeToChannel(Object msg, Promise<Void> listener) {
        return this.writeToChannel(msg, listener == null ? this.voidPromise : this.newChannelPromise(listener));
    }

    public final boolean writeToChannel(Object msg, ChannelPromise promise) {
        return this.writeToChannel(msg, false, promise);
    }

    public final boolean writeToChannel(final Object msg, final boolean forceFlush, final ChannelPromise promise) {
        return this.writeToChannel(new MessageWrite(){

            @Override
            public void write() {
                VertxConnection.this.write(msg, forceFlush, promise);
            }

            @Override
            public void cancel(Throwable cause) {
                promise.setFailure(cause);
            }
        });
    }

    public final boolean writeToChannel(MessageWrite msg) {
        return this.outboundMessageQueue.write(msg);
    }

    public final void flush() {
        this.flush(this.voidPromise);
    }

    public final void flush(ChannelPromise promise) {
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, promise);
    }

    public final void flush(FutureListener<Void> listener) {
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, listener == null ? this.voidPromise : this.wrap(listener));
    }

    public boolean writeQueueFull() {
        return !this.outboundMessageQueue.isWritable();
    }

    private void sendFileRegion(FileChannel fc, long offset2, long length, ChannelPromise writeFuture) {
        if (length < 0x100000L) {
            DefaultFileRegion region = new DefaultFileRegion(fc, offset2, length);
            region.retain();
            this.writeToChannel((Object)region, writeFuture);
        } else {
            ChannelPromise promise = this.chctx.newPromise();
            DefaultFileRegion region = new DefaultFileRegion(fc, offset2, 0x100000L);
            region.retain();
            this.writeToChannel((Object)region, promise);
            promise.addListener(future -> {
                if (future.isSuccess()) {
                    this.sendFileRegion(fc, offset2 + 0x100000L, length - 0x100000L, writeFuture);
                } else {
                    log.error(future.cause().getMessage(), future.cause());
                    writeFuture.setFailure(future.cause());
                }
            });
        }
    }

    public ChannelFuture sendFile(FileChannel fc, long offset2, long length) {
        ChannelPromise writeFuture = this.chctx.newPromise();
        if (!this.supportsFileRegion()) {
            try {
                this.writeToChannel((Object)new ChunkedNioFile(fc, offset2, length, 8192){

                    @Override
                    public void close() {
                    }
                }, writeFuture);
            }
            catch (IOException e) {
                return this.chctx.newFailedFuture(e);
            }
        } else {
            this.sendFileRegion(fc, offset2, length, writeFuture);
        }
        return writeFuture;
    }

    public void doSetWriteQueueMaxSize(int size2) {
        ChannelConfig config2 = this.chctx.channel().config();
        config2.setWriteBufferWaterMark(new WriteBufferWaterMark(size2 / 2, size2));
    }

    private class InternalMessageChannel
    extends OutboundMessageQueue<MessageWrite>
    implements Predicate<MessageWrite>,
    OutboundWriteQueue {
        public InternalMessageChannel(io.vertx.core.internal.EventExecutor eventLoop) {
            super(eventLoop);
        }

        @Override
        public boolean test(MessageWrite msg) {
            if (VertxConnection.this.channelWritable) {
                msg.write();
                return true;
            }
            return false;
        }

        @Override
        protected void handleDispose(MessageWrite write) {
            write.cancel(ConnectionBase.CLOSED_EXCEPTION);
        }

        @Override
        protected void startDraining() {
            VertxConnection.this.draining = true;
        }

        @Override
        protected void stopDraining() {
            VertxConnection.this.draining = false;
            if (!VertxConnection.this.read) {
                VertxConnection.this.checkFlush();
            }
        }

        @Override
        protected void handleDrained() {
            VertxConnection.this.handleWriteQueueDrained();
        }
    }

    private final class DirectOutboundMessageQueue
    implements OutboundWriteQueue {
        private DirectOutboundMessageQueue() {
        }

        @Override
        public boolean isWritable() {
            return VertxConnection.this.channelWritable;
        }

        @Override
        public boolean write(MessageWrite msg) {
            msg.write();
            return true;
        }

        @Override
        public boolean tryDrain() {
            VertxConnection.this.handleWriteQueueDrained();
            return false;
        }

        @Override
        public void close() {
        }
    }

    private static interface OutboundWriteQueue {
        public boolean isWritable();

        public boolean write(MessageWrite var1);

        public boolean tryDrain();

        public void close();
    }
}

