/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.ClusterSerializable;
import java.util.Objects;

public class NodeInfo
implements ClusterSerializable {
    private String host;
    private int port;
    private JsonObject metadata;

    public NodeInfo() {
    }

    public NodeInfo(String host, int port, JsonObject metadata2) {
        this.host = Objects.requireNonNull(host, "host is null");
        Arguments.requireInRange(port, 1, 65535, "Not an actual port: " + port);
        this.port = port;
        this.metadata = metadata2;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public JsonObject metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        if (this.port != nodeInfo.port) {
            return false;
        }
        if (!this.host.equals(nodeInfo.host)) {
            return false;
        }
        return Objects.equals(this.metadata, nodeInfo.metadata);
    }

    public int hashCode() {
        int result2 = this.host.hashCode();
        result2 = 31 * result2 + this.port;
        result2 = 31 * result2 + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "NodeInfo{host='" + this.host + "', port=" + this.port + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        buffer.appendInt(this.host.length()).appendString(this.host);
        buffer.appendInt(this.port);
        if (this.metadata == null) {
            buffer.appendInt(-1);
        } else {
            Buffer buf = this.metadata.toBuffer();
            buffer.appendInt(buf.length()).appendBuffer(buf);
        }
    }

    @Override
    public int readFromBuffer(int start2, Buffer buffer) {
        int pos = start2;
        int len = buffer.getInt(pos);
        this.host = buffer.getString(pos += 4, pos + len);
        this.port = buffer.getInt(pos += len);
        len = buffer.getInt(pos += 4);
        pos += 4;
        if (len == 0) {
            this.metadata = new JsonObject();
        } else if (len > 0) {
            this.metadata = new JsonObject(buffer.getBuffer(pos, pos + len));
            pos += len;
        }
        return pos;
    }
}

